/*
 * Decompiled with CFR 0.152.
 */
package com.kangxin.common.base.rmvp;

import android.os.Bundle;
import androidx.annotation.Nullable;
import com.kangxin.common.base.mvp.BaseModel;
import com.kangxin.common.base.rmvp.BaseActivity;
import com.kangxin.common.base.rmvp.BasePresenter;
import com.kangxin.common.base.rmvp.IView;
import java.lang.reflect.Array;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;

public abstract class MvpActivity<V extends IView, P extends BasePresenter<V, ? extends BaseModel>>
extends BaseActivity
implements IView {
    protected P p;

    @Override
    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.p = this.autoCreatPresenter();
        if (this.p != null) {
            ((BasePresenter)this.p).injectView((MvpActivity)this);
        }
    }

    private P autoCreatPresenter() {
        try {
            Type superClass = this.getClass().getGenericSuperclass();
            Type type = ((ParameterizedType)superClass).getActualTypeArguments()[1];
            Class<?> clazz = MvpActivity.getRawType(type);
            return (P)((BasePresenter)clazz.newInstance());
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private static Class<?> getRawType(Type type) {
        if (type instanceof Class) {
            return (Class)type;
        }
        if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            Type rawType = parameterizedType.getRawType();
            return (Class)rawType;
        }
        if (type instanceof GenericArrayType) {
            Type componentType = ((GenericArrayType)type).getGenericComponentType();
            return Array.newInstance(MvpActivity.getRawType(componentType), 0).getClass();
        }
        if (type instanceof TypeVariable) {
            return Object.class;
        }
        if (type instanceof WildcardType) {
            return MvpActivity.getRawType(((WildcardType)type).getUpperBounds()[0]);
        }
        String className = type == null ? "null" : type.getClass().getName();
        throw new IllegalArgumentException("Expected a Class, ParameterizedType, or GenericArrayType, but <" + type + "> is of type " + className);
    }

    protected void injectPresenter(P p) {
        if (p == null) {
            try {
                throw new Exception("P Instance dose not null");
            }
            catch (Exception e) {
                e.printStackTrace();
                return;
            }
        }
        this.p = p;
        ((BasePresenter)p).injectView((MvpActivity)this);
    }

    @Override
    public void showLoading() {
        super.showLoading();
    }

    @Override
    public void hideLoading() {
        super.hideLoading();
    }

    @Override
    protected void onDestroy() {
        ((BasePresenter)this.p).destroy();
        this.p = null;
        super.onDestroy();
    }
}

