/*
 * Decompiled with CFR 0.152.
 */
package com.kangxin.common.rx;

import android.accounts.NetworkErrorException;
import android.app.Activity;
import android.app.ProgressDialog;
import android.content.Context;
import android.content.ContextWrapper;
import android.util.Log;
import com.blankj.utilcode.util.ToastUtils;
import com.google.gson.JsonParseException;
import com.kangxin.common.global.ErrorCode;
import com.umeng.analytics.MobclickAgent;
import io.reactivex.observers.DefaultObserver;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import retrofit2.HttpException;

public abstract class ProgressDialogObserver<T>
extends DefaultObserver<T> {
    private static final String TAG = "ProgressDialogObserver";
    final String MSG = "\u8054\u7cfb\u5f00\u53d1\u4eba\u5458\u89e3\u51b3\u95ee\u9898\uff0c\u9519\u8bef\u7801";
    String msg = "";
    private Context mContext = this.attachContext();
    private ProgressDialog progressDialog;

    protected void onStart() {
        Log.i((String)"ProgressDialog", (String)("onstart " + Thread.currentThread().getName()));
        this.onComplete();
        if (this.progressDialog != null) {
            this.progressDialog.show();
        }
    }

    public abstract void onNext(T var1);

    public void onError(Throwable t) {
        Context context;
        Log.i((String)"ProgressDialog", (String)("onerror " + Thread.currentThread().getName()));
        t.printStackTrace();
        if (this.progressDialog != null && this.progressDialog.isShowing()) {
            context = ((ContextWrapper)this.progressDialog.getContext()).getBaseContext();
            if (context instanceof Activity) {
                if (!((Activity)context).isFinishing() && !((Activity)context).isDestroyed()) {
                    this.progressDialog.dismiss();
                }
            } else {
                this.progressDialog.dismiss();
            }
        }
        this.msg = t instanceof SocketTimeoutException ? "\u8054\u7cfb\u5f00\u53d1\u4eba\u5458\u89e3\u51b3\u95ee\u9898\uff0c\u9519\u8bef\u7801" + ErrorCode.INSTANCE.getSOCKET_TIME_OUT_ERROR() : (t instanceof NetworkErrorException || t instanceof HttpException ? "\u8054\u7cfb\u5f00\u53d1\u4eba\u5458\u89e3\u51b3\u95ee\u9898\uff0c\u9519\u8bef\u7801" + ErrorCode.INSTANCE.getNET_ERROR() : (t instanceof JsonParseException ? "\u8054\u7cfb\u5f00\u53d1\u4eba\u5458\u89e3\u51b3\u95ee\u9898\uff0c\u9519\u8bef\u7801" + ErrorCode.INSTANCE.getJSON_PARSE_ERROR() : (t instanceof NullPointerException ? "\u8054\u7cfb\u5f00\u53d1\u4eba\u5458\u89e3\u51b3\u95ee\u9898\uff0c\u9519\u8bef\u7801" + ErrorCode.INSTANCE.getNULL_POINT_ERROR() : (t instanceof ArrayIndexOutOfBoundsException ? "\u8054\u7cfb\u5f00\u53d1\u4eba\u5458\u89e3\u51b3\u95ee\u9898\uff0c\u9519\u8bef\u7801" + ErrorCode.INSTANCE.getARRAY_INDEX_OUT_ERROR() : (t instanceof com.jakewharton.retrofit2.adapter.rxjava2.HttpException ? "\u8054\u7cfb\u5f00\u53d1\u4eba\u5458\u89e3\u51b3\u95ee\u9898\uff0c\u9519\u8bef\u7801" + ErrorCode.INSTANCE.getNET_ERROR() : (t instanceof UnknownHostException ? "\u8bf7\u68c0\u67e5\u7f51\u7edc\u8fde\u63a5\u662f\u5426\u53ef\u7528" : "\u8054\u7cfb\u5f00\u53d1\u4eba\u5458\u89e3\u51b3\u95ee\u9898\uff0c\u9519\u8bef\u7801" + ErrorCode.INSTANCE.getNO_KNOW_ERROR()))))));
        if (this.progressDialog != null && this.progressDialog.isShowing()) {
            context = ((ContextWrapper)this.progressDialog.getContext()).getBaseContext();
            if (context instanceof Activity) {
                if (!((Activity)context).isFinishing() && !((Activity)context).isDestroyed()) {
                    this.progressDialog.dismiss();
                }
            } else {
                this.progressDialog.dismiss();
            }
        }
        MobclickAgent.reportError((Context)this.mContext, (Throwable)t);
        ToastUtils.showShort((CharSequence)this.msg);
    }

    public void onComplete() {
        Log.i((String)"ProgressDialog", (String)("onstart " + Thread.currentThread().getName()));
        if (this.progressDialog != null && this.progressDialog.isShowing()) {
            Context context = ((ContextWrapper)this.progressDialog.getContext()).getBaseContext();
            if (context instanceof Activity) {
                if (!((Activity)context).isFinishing() && !((Activity)context).isDestroyed()) {
                    this.progressDialog.dismiss();
                }
            } else {
                this.progressDialog.dismiss();
            }
        }
    }

    public ProgressDialogObserver() {
        if (this.mContext != null) {
            this.progressDialog = new ProgressDialog(this.mContext);
            this.initProgressDialog();
        }
    }

    protected abstract Context attachContext();

    private void initProgressDialog() {
        this.progressDialog.setTitle((CharSequence)"");
        this.progressDialog.setMessage((CharSequence)"\u52a0\u8f7d\u4e2d...");
    }
}

