/*
 * Decompiled with CFR 0.152.
 */
package com.kangxin.common.widget;

import android.content.Context;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.TextView;
import androidx.annotation.Nullable;
import com.kangxin.common.R;

public class SwitchButtonView
extends LinearLayout {
    private TextView leftTextView;
    private TextView rightTextView;
    private Context mContext;
    private OnClickListener listener;

    public SwitchButtonView(Context context) {
        this(context, null);
    }

    public SwitchButtonView(Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public SwitchButtonView(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.mContext = context;
        this.init();
        this.resolveAttribute();
        this.newInstanceTextView();
        this.addChildView();
        this.dispatchEvent();
    }

    private void dispatchEvent() {
        this.leftTextView.setOnClickListener(v -> {
            this.leftTextView.setBackground(this.getResources().getDrawable(R.drawable.by_background_circle_white_right));
            this.rightTextView.setBackground(null);
            this.leftTextView.setTextColor(this.mContext.getResources().getColor(R.color.colorPrimary));
            this.rightTextView.setTextColor(-1);
            LinearLayout.LayoutParams layoutParams = new LinearLayout.LayoutParams(0, -1, 1.5f);
            this.leftTextView.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
            LinearLayout.LayoutParams rightParams = new LinearLayout.LayoutParams(0, -1, 1.0f);
            this.rightTextView.setLayoutParams((ViewGroup.LayoutParams)rightParams);
            if (this.listener != null) {
                this.listener.onLeftClick();
            }
        });
        this.rightTextView.setOnClickListener(v -> {
            this.rightTextView.setBackground(this.getResources().getDrawable(R.drawable.by_background_circle_white_right));
            this.leftTextView.setBackground(null);
            this.rightTextView.setTextColor(this.mContext.getResources().getColor(R.color.colorPrimary));
            this.leftTextView.setTextColor(-1);
            LinearLayout.LayoutParams layoutParams = new LinearLayout.LayoutParams(0, -1, 1.0f);
            this.leftTextView.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
            LinearLayout.LayoutParams rightParams = new LinearLayout.LayoutParams(0, -1, 1.5f);
            this.rightTextView.setLayoutParams((ViewGroup.LayoutParams)rightParams);
            if (this.listener != null) {
                this.listener.onRightClick();
            }
        });
    }

    private void init() {
    }

    private void addChildView() {
        this.addView((View)this.leftTextView, (ViewGroup.LayoutParams)new LinearLayout.LayoutParams(0, -1, 1.5f));
        this.addView((View)this.rightTextView, (ViewGroup.LayoutParams)new LinearLayout.LayoutParams(0, -1, 1.0f));
    }

    private void newInstanceTextView() {
        this.leftTextView = new TextView(this.mContext);
        this.leftTextView.setText((CharSequence)"\u7533\u8bf7");
        this.leftTextView.setTextColor(this.mContext.getResources().getColor(R.color.colorPrimary));
        this.leftTextView.setTextSize(12.0f);
        this.leftTextView.setGravity(17);
        this.leftTextView.setBackground(this.getResources().getDrawable(R.drawable.by_background_circle_white_right));
        this.rightTextView = new TextView(this.mContext);
        this.rightTextView.setText((CharSequence)"\u63a5\u8bca");
        this.rightTextView.setTextColor(-1);
        this.rightTextView.setTextSize(12.0f);
        this.rightTextView.setGravity(17);
    }

    private void resolveAttribute() {
    }

    public void setListener(OnClickListener listener) {
        this.listener = listener;
    }

    public static interface OnClickListener {
        public void onLeftClick();

        public void onRightClick();
    }
}

