/*
 * Decompiled with CFR 0.152.
 */
package com.kangxin.common;

import android.content.Context;
import com.kangxin.common.imageloader.ImageLoader;
import com.kangxin.common.imageloader.Show;
import com.kangxin.common.imageloader.ZipStrategy;
import com.kangxin.common.imageloader.factory.GlideClient;
import com.kangxin.common.imageloader.factory.GlideImageLoader;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;

public final class Pretty {
    private static ImageLoader proxy;
    private final Context mContext;
    private final Show.Factory showFatory;
    private static ImageLoader imageLoader;
    private final ZipStrategy zipStrategy;
    private int style;

    private Pretty(Context mContext, Show.Factory showFatory, ImageLoader imageLoader, ZipStrategy zipStrategy, int style) {
        this.mContext = mContext;
        this.showFatory = showFatory;
        Pretty.imageLoader = imageLoader;
        this.zipStrategy = zipStrategy;
        this.style = style;
    }

    public static ImageLoader create() {
        if (proxy == null) {
            proxy = (ImageLoader)Proxy.newProxyInstance(imageLoader.getClass().getClassLoader(), imageLoader.getClass().getInterfaces(), new InvocationHandler(){

                @Override
                public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                    ImageLoader invoke = null;
                    invoke = (ImageLoader)method.invoke((Object)imageLoader, args);
                    return invoke;
                }
            });
        }
        return proxy;
    }

    static {
        imageLoader = null;
    }

    public static final class Builder {
        private Show.Factory showFactory;
        private int style = 1;
        private ImageLoader imageLoader;
        private ZipStrategy zipStrategy;
        private Context mContext;

        public Builder init(Context context) {
            this.mContext = context;
            return this;
        }

        public Builder setShowFactory(Show.Factory factory) {
            this.showFactory = factory;
            return this;
        }

        public Builder setImageLoader(ImageLoader loader) {
            this.imageLoader = loader;
            return this;
        }

        public Builder setZipStrategy(ZipStrategy zipStrategy) {
            this.zipStrategy = zipStrategy;
            return this;
        }

        public void setStyle(int style) {
            this.style = style;
        }

        public Pretty build() {
            if (this.showFactory == null) {
                this.showFactory = new GlideClient(this.mContext);
            }
            if (this.imageLoader == null) {
                this.imageLoader = new GlideImageLoader(this.mContext);
            }
            if (this.zipStrategy == null) {
                // empty if block
            }
            return new Pretty(this.mContext, this.showFactory, this.imageLoader, this.zipStrategy, this.style);
        }
    }
}

