/*
 * Decompiled with CFR 0.152.
 */
package com.kangxin.common.http.interceptor;

import android.content.Context;
import android.content.SharedPreferences;
import android.text.TextUtils;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;

public class SaveCookieInterceptor
implements Interceptor {
    private Context mContext;
    private static final String COOKIE_PREF = "cookies_prefs";

    public SaveCookieInterceptor(Context context) {
        this.mContext = context;
    }

    public Response intercept(Interceptor.Chain chain) throws IOException {
        Request request = chain.request();
        Response response = chain.proceed(request);
        if (!response.headers("set-cookie").isEmpty()) {
            List cookies = response.headers("set-cookie");
            String cookie = this.encodeCookie(cookies);
            this.saveCookie(request.url().toString(), request.url().host(), cookie);
        }
        return response;
    }

    private String encodeCookie(List<String> cookies) {
        StringBuilder sb = new StringBuilder();
        HashSet<String> set = new HashSet<String>();
        for (String cookie : cookies) {
            String[] arr;
            for (String s : arr = cookie.split(";")) {
                if (set.contains(s)) continue;
                set.add(s);
            }
        }
        for (String cookie : set) {
            sb.append(cookie).append(";");
        }
        int last = sb.lastIndexOf(";");
        if (sb.length() - 1 == last) {
            sb.deleteCharAt(last);
        }
        return sb.toString();
    }

    private void saveCookie(String url, String domain, String cookies) {
        SharedPreferences sp = this.mContext.getSharedPreferences(COOKIE_PREF, 0);
        SharedPreferences.Editor editor = sp.edit();
        if (TextUtils.isEmpty((CharSequence)url)) {
            throw new NullPointerException("url is null.");
        }
        editor.putString(url, cookies);
        if (!TextUtils.isEmpty((CharSequence)domain)) {
            editor.putString(domain, cookies);
        }
        editor.apply();
    }
}

