/*
 * Decompiled with CFR 0.152.
 */
package com.kangxin.common.util;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.LinearGradient;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Shader;
import android.graphics.Xfermode;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.text.Layout;
import android.text.StaticLayout;
import android.text.TextPaint;
import android.util.Base64;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;

@SuppressLint(value={"UseValueOf"})
public class BitMapUtils {
    public static Bitmap toRoundCorner(Bitmap bitmap, int pixels) {
        Bitmap output = Bitmap.createBitmap((int)bitmap.getWidth(), (int)bitmap.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(output);
        int color = -16777216;
        Paint paint = new Paint();
        Rect rect = new Rect(0, 0, bitmap.getWidth(), bitmap.getHeight());
        RectF rectF = new RectF(rect);
        float roundPx = pixels;
        paint.setAntiAlias(true);
        canvas.drawARGB(0, 0, 0, 0);
        paint.setColor(-16777216);
        canvas.drawRoundRect(rectF, roundPx, roundPx, paint);
        paint.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.SRC_IN));
        canvas.drawBitmap(bitmap, rect, rect, paint);
        return output;
    }

    public static Bitmap toRoundCorner(Bitmap bitmap, int w, int h, int pixels) {
        Bitmap output = Bitmap.createBitmap((int)w, (int)h, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(output);
        int color = -12434878;
        Paint paint = new Paint();
        Rect rect = new Rect(0, 0, w, h);
        RectF rectF = new RectF(rect);
        float roundPx = pixels;
        paint.setAntiAlias(true);
        canvas.drawARGB(0, 0, 0, 0);
        paint.setColor(-12434878);
        canvas.drawRoundRect(rectF, roundPx, roundPx, paint);
        paint.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.SRC_IN));
        canvas.drawBitmap(bitmap, rect, rect, paint);
        return output;
    }

    public static int changeColor(String startColor, String endColor, float process) {
        int start = Color.parseColor((String)startColor);
        int startR = start >> 16 & 0xFF;
        int startG = start >> 8 & 0xFF;
        int startB = start & 0xFF;
        int end = Color.parseColor((String)endColor);
        int endR = end >> 16 & 0xFF;
        int endG = end >> 8 & 0xFF;
        int endB = end & 0xFF;
        float colorR = (float)startR + (float)(endR - startR) * process;
        float colorG = (float)startG + (float)(endG - startG) * process;
        float colorB = (float)startB + (float)(endB - startB) * process;
        return Color.rgb((int)((int)colorR), (int)((int)colorG), (int)((int)colorB));
    }

    public static Drawable bitmap2Drawable(Bitmap bitmap) {
        BitmapDrawable bitmapDrawable = new BitmapDrawable(bitmap);
        return bitmapDrawable;
    }

    public static Bitmap bitmapFromDrawable(Drawable drawable) {
        Bitmap bitmap = Bitmap.createBitmap((int)drawable.getIntrinsicWidth(), (int)drawable.getIntrinsicHeight(), (Bitmap.Config)(drawable.getOpacity() != -1 ? Bitmap.Config.ARGB_8888 : Bitmap.Config.RGB_565));
        Canvas canvas = new Canvas();
        canvas.setBitmap(bitmap);
        drawable.setBounds(0, 0, drawable.getIntrinsicWidth(), drawable.getIntrinsicHeight());
        drawable.draw(canvas);
        return bitmap;
    }

    public static byte[] bitmap2Bytes(Bitmap bitmap) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        bitmap.compress(Bitmap.CompressFormat.PNG, 100, (OutputStream)baos);
        return baos.toByteArray();
    }

    public static Bitmap bitmapFromBytes(byte[] data) {
        if (data.length != 0) {
            return BitmapFactory.decodeByteArray((byte[])data, (int)0, (int)data.length);
        }
        return null;
    }

    public static Bitmap bitmap2Resize(Bitmap bitmap, int width, int height) {
        int tempWidth = bitmap.getWidth();
        int tempHeight = bitmap.getHeight();
        Matrix matrix = new Matrix();
        float scaleWidth = (float)width / (float)tempWidth;
        float scaleHeight = (float)height / (float)tempHeight;
        matrix.postScale(scaleWidth, scaleHeight);
        Bitmap newBitmap = Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)0, (int)tempWidth, (int)tempHeight, (Matrix)matrix, (boolean)true);
        return newBitmap;
    }

    public static Bitmap bitmap2Round(Bitmap bitmap, float roundPx) {
        Bitmap output = Bitmap.createBitmap((int)bitmap.getWidth(), (int)bitmap.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(output);
        Paint paint = new Paint();
        Rect rect = new Rect(0, 0, bitmap.getWidth(), bitmap.getHeight());
        RectF rectF = new RectF(rect);
        paint.setAntiAlias(true);
        canvas.drawARGB(0, 0, 0, 0);
        canvas.drawRoundRect(rectF, roundPx, roundPx, paint);
        paint.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.SRC_IN));
        canvas.drawBitmap(bitmap, rect, rect, paint);
        return output;
    }

    public static Bitmap bitmap2ReflectionImage(Bitmap bitmap, int reflectionImageDistance) {
        int reflectionGap = reflectionImageDistance;
        int width = bitmap.getWidth();
        int height = bitmap.getHeight();
        Matrix matrix = new Matrix();
        matrix.preScale(1.0f, -1.0f);
        Bitmap reflectionImage = Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)(height / 2), (int)width, (int)(height / 2), (Matrix)matrix, (boolean)false);
        Bitmap bitmapWithReflection = Bitmap.createBitmap((int)width, (int)(height + height / 2), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(bitmapWithReflection);
        canvas.drawBitmap(bitmap, 0.0f, 0.0f, null);
        canvas.drawBitmap(reflectionImage, 0.0f, (float)(height + reflectionGap), null);
        Paint paint = new Paint();
        LinearGradient shader = new LinearGradient(0.0f, (float)bitmap.getHeight(), 0.0f, (float)(bitmapWithReflection.getHeight() + reflectionGap), -1, 0xFFFFFF, Shader.TileMode.CLAMP);
        paint.setShader((Shader)shader);
        paint.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.DST_IN));
        canvas.drawRect(0.0f, (float)height, (float)width, (float)(bitmapWithReflection.getHeight() + reflectionGap), paint);
        return bitmapWithReflection;
    }

    public static Bitmap bitmap2WatermarkImage(Bitmap bitmap, Bitmap watermark) {
        if (bitmap == null) {
            return null;
        }
        int w = bitmap.getWidth();
        int h = bitmap.getHeight();
        Bitmap newb = Bitmap.createBitmap((int)w, (int)h, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas cv = new Canvas(newb);
        cv.drawBitmap(bitmap, 0.0f, 0.0f, null);
        Paint paint = new Paint();
        if (watermark != null) {
            int ww = watermark.getWidth();
            int wh = watermark.getHeight();
            paint.setAlpha(50);
            cv.drawBitmap(watermark, (float)(w - ww + 5), (float)(h - wh + 5), paint);
        }
        cv.save();
        cv.restore();
        return newb;
    }

    public static Bitmap bitmap2WatermarkText(Bitmap bitmap, String text, int textColor, int textSize, int x, int y, boolean isHorizentalCenter) {
        if (bitmap == null) {
            return null;
        }
        int w = bitmap.getWidth();
        int h = bitmap.getHeight();
        Bitmap newb = Bitmap.createBitmap((int)w, (int)h, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas cv = new Canvas(newb);
        cv.drawBitmap(bitmap, 0.0f, 0.0f, null);
        if (text != null) {
            TextPaint textPaint = new TextPaint();
            textPaint.setColor(textColor);
            textPaint.setTextSize((float)textSize);
            cv.translate((float)x, (float)y);
            StaticLayout layout2 = new StaticLayout((CharSequence)text, textPaint, w, isHorizentalCenter ? Layout.Alignment.ALIGN_CENTER : Layout.Alignment.ALIGN_NORMAL, 1.0f, 0.0f, true);
            layout2.draw(cv);
        }
        cv.save();
        cv.restore();
        return newb;
    }

    public static Bitmap getScaleBitmap(Bitmap bitmap, int width, int height) {
        return Bitmap.createScaledBitmap((Bitmap)bitmap, (int)width, (int)height, (boolean)true);
    }

    public static Bitmap getScaleBitmap(Bitmap bitmap, float scale) {
        Matrix matrix = new Matrix();
        matrix.postScale(scale, scale);
        Bitmap resizeBmp = Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)0, (int)bitmap.getWidth(), (int)bitmap.getHeight(), (Matrix)matrix, (boolean)true);
        return resizeBmp;
    }

    static int computeSampleSize(BitmapFactory.Options options, int minSideLength, int maxNumOfPixels) {
        int roundedSize;
        int initialSize = BitMapUtils.computeInitialSampleSize(options, minSideLength, maxNumOfPixels);
        if (initialSize <= 8) {
            for (roundedSize = 1; roundedSize < initialSize; roundedSize <<= 1) {
            }
        } else {
            roundedSize = (initialSize + 7) / 8 * 8;
        }
        return roundedSize;
    }

    private static int computeInitialSampleSize(BitmapFactory.Options options, int minSideLength, int maxNumOfPixels) {
        int upperBound;
        double w = options.outWidth;
        double h = options.outHeight;
        int lowerBound = maxNumOfPixels == -1 ? 1 : (int)Math.ceil(Math.sqrt(w * h / (double)maxNumOfPixels));
        int n = upperBound = minSideLength == -1 ? 128 : (int)Math.min(Math.floor(w / (double)minSideLength), Math.floor(h / (double)minSideLength));
        if (upperBound < lowerBound) {
            return lowerBound;
        }
        if (maxNumOfPixels == -1 && minSideLength == -1) {
            return 1;
        }
        if (minSideLength == -1) {
            return lowerBound;
        }
        return upperBound;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String GetBitMapStr(Bitmap bitmap, int quality) {
        String result = null;
        ByteArrayOutputStream baos = null;
        if (quality >= 2) {
            --quality;
        }
        try {
            if (bitmap != null) {
                baos = new ByteArrayOutputStream();
                bitmap.compress(Bitmap.CompressFormat.JPEG, quality, (OutputStream)baos);
                baos.flush();
                baos.close();
                byte[] bitmapBytes = baos.toByteArray();
                result = Base64.encodeToString((byte[])bitmapBytes, (int)0);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (baos != null) {
                    baos.flush();
                    baos.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    public static String ConvertBitmapToStr(Bitmap bmp) {
        String result = null;
        int targetSize = 0x500000;
        int size = 1;
        try {
            size = bmp.getRowBytes() * bmp.getHeight();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (targetSize > size) {
            result = BitMapUtils.GetBitMapStr(bmp, 100);
        } else {
            Double scale = Double.parseDouble("" + targetSize) / Double.parseDouble("" + size);
            int option = size / targetSize;
            result = BitMapUtils.GetBitMapStr(bmp, new Double(scale * 100.0).intValue());
        }
        return result;
    }

    public static Bitmap getDiskBitmap(String pathString) {
        Bitmap bitmap = null;
        try {
            BitmapFactory.Options options = new BitmapFactory.Options();
            options.inSampleSize = 2;
            File file = new File(pathString);
            if (file.exists()) {
                bitmap = BitmapFactory.decodeFile((String)pathString, (BitmapFactory.Options)options);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return bitmap;
    }

    public static Bitmap getDiskBitmap(String pathString, int option) {
        Bitmap bitmap = null;
        try {
            BitmapFactory.Options options = new BitmapFactory.Options();
            options.inSampleSize = option;
            File file = new File(pathString);
            if (file.exists()) {
                bitmap = BitmapFactory.decodeFile((String)pathString, (BitmapFactory.Options)options);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return bitmap;
    }

    public static int calculateInSampleSize(BitmapFactory.Options op, int reqWidth, int reqheight) {
        int originalWidth = op.outWidth;
        int originalHeight = op.outHeight;
        int inSampleSize = 1;
        if (originalWidth > reqWidth || originalHeight > reqheight) {
            int halfWidth = originalWidth / 2;
            int halfHeight = originalHeight / 2;
            inSampleSize *= 2;
            while (halfWidth / inSampleSize > reqWidth && halfHeight / inSampleSize > reqheight) {
                inSampleSize *= 2;
            }
        }
        return inSampleSize;
    }

    public static Bitmap scaleBitmap(String imagePath, int requestWidth, int requestHeight) {
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inJustDecodeBounds = true;
        BitmapFactory.decodeFile((String)imagePath, (BitmapFactory.Options)options);
        options.inSampleSize = BitMapUtils.calculateInSampleSize(options, requestWidth, requestHeight);
        options.inJustDecodeBounds = false;
        return BitmapFactory.decodeFile((String)imagePath, (BitmapFactory.Options)options);
    }

    public static String saveBitmap(Context context, Bitmap bitmap, String picName) {
        String path = context.getExternalCacheDir().getAbsolutePath();
        File f = new File(path + "/", picName);
        if (f.exists()) {
            f.delete();
        }
        try {
            FileOutputStream out = new FileOutputStream(f);
            bitmap.compress(Bitmap.CompressFormat.PNG, 90, (OutputStream)out);
            out.flush();
            out.close();
            return path + "/" + picName;
        }
        catch (Exception e) {
            return "";
        }
    }
}

