/*
 * Decompiled with CFR 0.152.
 */
package com.kangxin.common.util;

import android.util.Log;
import java.io.File;
import java.text.DecimalFormat;

public class FileUtils {
    public static final int SIZETYPE_B = 1;
    public static final int SIZETYPE_KB = 2;
    public static final int SIZETYPE_MB = 3;
    public static final int SIZETYPE_GB = 4;

    public static double getFileOrFilesSize(String filePath, int sizeType) {
        File file = new File(filePath);
        long blockSize = 0L;
        try {
            blockSize = file.isDirectory() ? FileUtils.getFileSizes(file) : FileUtils.getFileSize(file);
        }
        catch (Exception e) {
            e.printStackTrace();
            Log.e((String)"\u83b7\u53d6\u6587\u4ef6\u5927\u5c0f", (String)"\u83b7\u53d6\u5931\u8d25!");
        }
        return FileUtils.FormetFileSize(blockSize, sizeType);
    }

    public static String getAutoFileOrFilesSize(String filePath) {
        File file = new File(filePath);
        long blockSize = 0L;
        try {
            blockSize = file.isDirectory() ? FileUtils.getFileSizes(file) : FileUtils.getFileSize(file);
        }
        catch (Exception e) {
            e.printStackTrace();
            Log.e((String)"\u83b7\u53d6\u6587\u4ef6\u5927\u5c0f", (String)"\u83b7\u53d6\u5931\u8d25!");
        }
        return FileUtils.FormetFileSize(blockSize);
    }

    private static long getFileSize(File file) throws Exception {
        long size = 0L;
        if (file.exists()) {
            size = file.length();
        } else {
            file.createNewFile();
            Log.e((String)"\u83b7\u53d6\u6587\u4ef6\u5927\u5c0f", (String)"\u6587\u4ef6\u4e0d\u5b58\u5728!");
        }
        return size;
    }

    public static long getFileSize(String path) throws Exception {
        File file = new File(path);
        return FileUtils.getFileSize(file);
    }

    private static long getFileSizes(File f) throws Exception {
        long size = 0L;
        File[] flist = f.listFiles();
        for (int i = 0; i < flist.length; ++i) {
            if (flist[i].isDirectory()) {
                size += FileUtils.getFileSizes(flist[i]);
                continue;
            }
            size += FileUtils.getFileSize(flist[i]);
        }
        return size;
    }

    private static String FormetFileSize(long fileS) {
        DecimalFormat df = new DecimalFormat("#.00");
        String fileSizeString = "";
        String wrongSize = "0B";
        if (fileS == 0L) {
            return wrongSize;
        }
        fileSizeString = fileS < 1024L ? df.format((double)fileS) + "B" : (fileS < 0x100000L ? df.format((double)fileS / 1024.0) + "KB" : (fileS < 0x40000000L ? df.format((double)fileS / 1048576.0) + "MB" : df.format((double)fileS / 1.073741824E9) + "GB"));
        return fileSizeString;
    }

    private static double FormetFileSize(long fileS, int sizeType) {
        DecimalFormat df = new DecimalFormat("#.00");
        double fileSizeLong = 0.0;
        switch (sizeType) {
            case 1: {
                fileSizeLong = Double.valueOf(df.format((double)fileS));
                break;
            }
            case 2: {
                fileSizeLong = Double.valueOf(df.format((double)fileS / 1024.0));
                break;
            }
            case 3: {
                fileSizeLong = Double.valueOf(df.format((double)fileS / 1048576.0));
                break;
            }
            case 4: {
                fileSizeLong = Double.valueOf(df.format((double)fileS / 1.073741824E9));
                break;
            }
        }
        return fileSizeLong;
    }
}

