/*
 * Decompiled with CFR 0.152.
 */
package com.kangxin.common.util;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class VerifyUtil {
    public static boolean isMobilePhoneNumber(String str) {
        if (VerifyUtil.isNotBlank(str)) {
            Pattern pattern = Pattern.compile("[1][0-9]\\d{9}");
            Matcher matcher = pattern.matcher(str);
            return matcher.matches();
        }
        return false;
    }

    public static boolean isNotBlank(String str) {
        int strLen;
        if (str == null || (strLen = str.length()) == 0) {
            return false;
        }
        for (int i = 0; i < strLen; ++i) {
            if (Character.isWhitespace(str.charAt(i))) continue;
            return true;
        }
        return false;
    }

    public static boolean isValidCode(String str) {
        if (VerifyUtil.isNotBlank(str)) {
            Pattern pattern = Pattern.compile("^[0-9]{4,4}$");
            Matcher matcher = pattern.matcher(str);
            return matcher.matches();
        }
        return false;
    }

    public static boolean isAddressNumber(String str) {
        if (VerifyUtil.isNotBlank(str)) {
            Pattern pattern = Pattern.compile("^(010|02\\d|0[3-9]\\d{2})?\\d{6,8}$");
            Matcher matcher = pattern.matcher(str);
            return matcher.matches();
        }
        return false;
    }

    public static boolean isEmailAddress(String str) {
        if (VerifyUtil.isNotBlank(str)) {
            Pattern pattern = Pattern.compile("[\\w-]+(\\.[\\w-]+)*@[\\w-]+(\\.[\\w-]+)+");
            Matcher matcher = pattern.matcher(str);
            return matcher.matches();
        }
        return false;
    }

    public static boolean isUrl(String str) {
        if (VerifyUtil.isNotBlank(str)) {
            return str.startsWith("http");
        }
        return false;
    }

    public static boolean isIdNo(String cardcode) {
        String isIDCard1 = "^[1-9]\\d{7}((0\\d)|(1[0-2]))(([0|1|2]\\d)|3[0-1])\\d{3}$";
        String isIDCard2 = "^[1-9]\\d{5}[1-9]\\d{3}((0\\d)|(1[0-2]))(([0|1|2]\\d)|3[0-1])((\\d{4})|\\d{3}[A-Z])$";
        return cardcode.matches(isIDCard1) || cardcode.matches(isIDCard2);
    }

    public static String changeIdcard(String idcardNo) {
        if (idcardNo.length() == 15) {
            return VerifyUtil.toEighteen(idcardNo);
        }
        return idcardNo;
    }

    private static String toEighteen(String idCode) {
        idCode = idCode.substring(0, 6) + "19" + idCode.substring(6);
        char[] Ai = idCode.toCharArray();
        int[] Wi = new int[]{7, 9, 10, 5, 8, 4, 2, 1, 6, 3, 7, 9, 10, 5, 8, 4, 2};
        char[] verifyCode = new char[]{'1', '0', 'X', '9', '8', '7', '6', '5', '4', '3', '2'};
        int S = 0;
        for (int i = 0; i < Wi.length; ++i) {
            S += (Ai[i] - 48) * Wi[i];
        }
        int Y = S % 11;
        idCode = idCode + verifyCode[Y];
        return idCode;
    }

    public static boolean isInteger(String str) {
        String reg = "^[0-9]+(.[0-9]+)?$";
        return str.matches(reg);
    }
}

