/*
 * Decompiled with CFR 0.152.
 */
package com.kangxin.common.widget;

import android.animation.TimeInterpolator;
import android.content.Context;
import android.util.AttributeSet;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.DecelerateInterpolator;
import android.widget.ImageView;
import java.util.ArrayList;
import java.util.List;

public abstract class FoldLayout
extends ViewGroup
implements View.OnClickListener {
    private static final String TAG = "FoldViewGroup";
    private ImageView mIvFold;
    private int mDefaultFoldCount = 2;
    private int mDefaultItemId;
    private List<?> mData = new ArrayList();
    private OnItemOnClickListener mItemOnClickListener;

    public FoldLayout(Context context) {
        this(context, null);
    }

    public FoldLayout(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public FoldLayout(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    public FoldLayout setItemOnClickListener(OnItemOnClickListener itemOnClickListener) {
        this.mItemOnClickListener = itemOnClickListener;
        return this;
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        int contentHeight = 0;
        int contentWidth = FoldLayout.resolveSize((int)0, (int)widthMeasureSpec);
        int childCount = this.getChildCount();
        Log.e((String)TAG, (String)("onMeasure: ----------->childCount=" + childCount));
        for (int i = 0; i < childCount; ++i) {
            View child = this.getChildAt(i);
            if (child.getVisibility() == 8) continue;
            this.measureChild(child, widthMeasureSpec, heightMeasureSpec);
            int measuredHeight = child.getMeasuredHeight();
            contentHeight += measuredHeight;
        }
        this.setMeasuredDimension(contentWidth, contentHeight);
    }

    public int getAllCount() {
        if (this.mData != null) {
            return this.mData.size();
        }
        return 0;
    }

    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        Log.e((String)TAG, (String)("onLayout: ------------>" + changed));
        int paddingTop = this.getPaddingTop();
        int paddingLeft = this.getPaddingLeft();
        int childCount = this.getChildCount();
        int lineHeight = 0;
        for (int i = 0; i < childCount; ++i) {
            View child = this.getChildAt(i);
            if (child.getVisibility() == 8) continue;
            int measuredHeight = child.getMeasuredHeight();
            int measuredWidth = child.getMeasuredWidth();
            child.layout(paddingLeft, lineHeight, paddingLeft + measuredWidth, measuredHeight + lineHeight);
            lineHeight += paddingTop + measuredHeight;
        }
    }

    public <T> FoldLayout setAdapter(int itemViewId, List<T> data) {
        this.mData = data;
        int defaultFoldCount = this.mDefaultFoldCount;
        if (data != null) {
            int len = data.size();
            for (int i = 0; i < len; ++i) {
                T o = data.get(i);
                View itemView = LayoutInflater.from((Context)this.getContext()).inflate(itemViewId, (ViewGroup)this, false);
                itemView.setTag((Object)i);
                itemView.setOnClickListener((View.OnClickListener)this);
                if (i >= defaultFoldCount) {
                    itemView.setVisibility(8);
                }
                this.dispatchChildView(itemView, o);
                this.addView(itemView);
            }
        }
        return this;
    }

    protected abstract void dispatchChildView(View var1, Object var2);

    public void onClick(View v) {
        int childCount = this.getChildCount();
        List<?> mData = this.mData;
        int p = (Integer)v.getTag();
        for (int i = 0; i < childCount; ++i) {
            if (p == i) {
                v.setActivated(true);
                continue;
            }
            View child = this.getChildAt(i);
            child.setActivated(false);
        }
        OnItemOnClickListener itemOnClickListener = this.mItemOnClickListener;
        if (itemOnClickListener != null) {
            Object item = mData.get(p);
            itemOnClickListener.onWorkInfoItemClick(v, p, item);
        }
    }

    private void ivShowAdvantageAnimate(float rotation) {
        ImageView ivFold = this.mIvFold;
        ivFold.animate().cancel();
        ivFold.animate().setInterpolator((TimeInterpolator)new DecelerateInterpolator()).setDuration(360L).rotation(rotation).start();
    }

    public void foldView() {
        this.notifyChild(8, this.mDefaultFoldCount);
    }

    public void unfoldView() {
        this.notifyChild(0, this.mDefaultFoldCount);
    }

    private void notifyChild(int visible, int index) {
        int childCount = this.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            View child = this.getChildAt(i);
            if (i < index) continue;
            child.setVisibility(visible);
        }
    }

    public static interface OnItemOnClickListener {
        public void onWorkInfoItemClick(View var1, int var2, Object var3);
    }
}

