/*
 * Decompiled with CFR 0.152.
 */
package com.kangxin.common.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.text.SpannableString;
import android.text.style.ForegroundColorSpan;
import android.util.AttributeSet;
import androidx.annotation.Nullable;
import androidx.appcompat.widget.AppCompatTextView;
import com.kangxin.common.R;

public class SpanColorTextView
extends AppCompatTextView {
    private SpannableString spannableString;
    private ForegroundColorSpan foregroundColorSpan;

    public SpanColorTextView(Context context) {
        this(context, null);
    }

    public SpanColorTextView(Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public SpanColorTextView(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        TypedArray typedArray = context.obtainStyledAttributes(attrs, R.styleable.SpanColorTextView);
        String text = typedArray.getString(R.styleable.SpanColorTextView_mText);
        int start = typedArray.getInt(R.styleable.SpanColorTextView_start, 0);
        int end = typedArray.getInt(R.styleable.SpanColorTextView_end, 0);
        int color = typedArray.getColor(R.styleable.SpanColorTextView_spanColor, -16777216);
        String subText = typedArray.getString(R.styleable.SpanColorTextView_subText);
        int subStart = text.indexOf(subText);
        int subEnd = subText.toCharArray().length + subStart;
        if (start == 0 && end == 0) {
            start = subStart;
            end = subEnd;
        }
        this.init(text, start, end, color);
    }

    private void init(String text, int start, int end, int color) {
        this.spannableString = new SpannableString((CharSequence)text);
        this.foregroundColorSpan = new ForegroundColorSpan(color);
        this.spannableString.setSpan((Object)this.foregroundColorSpan, start, end, 33);
        this.setText((CharSequence)this.spannableString);
    }
}

