/*
 * Decompiled with CFR 0.152.
 */
package com.yhao.floatwindow;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.ObjectAnimator;
import android.animation.PropertyValuesHolder;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.annotation.SuppressLint;
import android.content.Context;
import android.os.Build;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.animation.DecelerateInterpolator;
import com.yhao.floatwindow.FloatLifecycle;
import com.yhao.floatwindow.FloatPhone;
import com.yhao.floatwindow.FloatToast;
import com.yhao.floatwindow.FloatView;
import com.yhao.floatwindow.FloatWindow;
import com.yhao.floatwindow.IFloatWindow;
import com.yhao.floatwindow.LifecycleListener;
import com.yhao.floatwindow.Util;

public class IFloatWindowImpl
extends IFloatWindow {
    private FloatWindow.B mB;
    private FloatView mFloatView;
    private FloatLifecycle mFloatLifecycle;
    private boolean isShow;
    private boolean once = true;
    private ValueAnimator mAnimator;
    private TimeInterpolator mDecelerateInterpolator;
    private float downX;
    private float downY;
    private float upX;
    private float upY;
    private boolean mClick = false;
    private int mSlop;
    private int statusBarHeight = 0;
    private int screenHeight = 0;
    private int screenWidth = 0;

    private IFloatWindowImpl() {
    }

    IFloatWindowImpl(FloatWindow.B b) {
        this.mB = b;
        this.statusBarHeight = Util.getStatusBarHeight(this.mB.mApplicationContext);
        this.screenHeight = Util.getScreenHeight(this.mB.mApplicationContext);
        this.screenWidth = Util.getScreenWidth(this.mB.mApplicationContext);
        if (this.mB.mMoveType == 0) {
            this.mFloatView = Build.VERSION.SDK_INT >= 25 ? new FloatPhone(b.mApplicationContext, this.mB.mPermissionListener) : new FloatToast(b.mApplicationContext);
        } else {
            this.mFloatView = new FloatPhone(b.mApplicationContext, this.mB.mPermissionListener);
            this.initTouchEvent();
        }
        this.mFloatView.setSize(this.mB.mWidth, this.mB.mHeight);
        this.mFloatView.setGravity(this.mB.gravity, this.mB.xOffset, this.mB.yOffset);
        this.mFloatView.setView(this.mB.mView);
        this.mFloatLifecycle = new FloatLifecycle(this.mB.mApplicationContext, this.mB.mShow, this.mB.mActivities, new LifecycleListener(){

            @Override
            public void onShow() {
                IFloatWindowImpl.this.show();
            }

            @Override
            public void onHide() {
                IFloatWindowImpl.this.hide();
            }

            @Override
            public void onBackToDesktop() {
                if (!((IFloatWindowImpl)IFloatWindowImpl.this).mB.mDesktopShow) {
                    IFloatWindowImpl.this.hide();
                }
                if (((IFloatWindowImpl)IFloatWindowImpl.this).mB.mViewStateListener != null) {
                    ((IFloatWindowImpl)IFloatWindowImpl.this).mB.mViewStateListener.onBackToDesktop();
                }
            }
        });
    }

    @Override
    public void show() {
        if (this.once) {
            this.mFloatView.init();
            this.once = false;
            this.isShow = true;
        } else {
            if (this.isShow) {
                return;
            }
            this.getView().setVisibility(0);
            this.isShow = true;
        }
        if (this.mB.mViewStateListener != null) {
            this.mB.mViewStateListener.onShow();
        }
    }

    @Override
    public void hide() {
        if (this.once || !this.isShow) {
            return;
        }
        this.getView().setVisibility(4);
        this.isShow = false;
        if (this.mB.mViewStateListener != null) {
            this.mB.mViewStateListener.onHide();
        }
    }

    @Override
    public boolean isShowing() {
        return this.isShow;
    }

    @Override
    void dismiss() {
        this.mFloatView.dismiss();
        this.isShow = false;
        if (this.mB.mViewStateListener != null) {
            this.mB.mViewStateListener.onDismiss();
        }
    }

    @Override
    public void updateX(int x) {
        this.checkMoveType();
        this.mB.xOffset = x;
        this.mFloatView.updateX(x);
    }

    @Override
    public void updateY(int y) {
        this.checkMoveType();
        this.mB.yOffset = y;
        this.mFloatView.updateY(y);
    }

    @Override
    public void updateX(int screenType, float ratio) {
        this.checkMoveType();
        this.mB.xOffset = (int)((float)(screenType == 0 ? Util.getScreenWidth(this.mB.mApplicationContext) : Util.getScreenHeight(this.mB.mApplicationContext)) * ratio);
        this.mFloatView.updateX(this.mB.xOffset);
    }

    @Override
    public void updateY(int screenType, float ratio) {
        this.checkMoveType();
        this.mB.yOffset = (int)((float)(screenType == 0 ? Util.getScreenWidth(this.mB.mApplicationContext) : Util.getScreenHeight(this.mB.mApplicationContext)) * ratio);
        this.mFloatView.updateY(this.mB.yOffset);
    }

    @Override
    public int getX() {
        return this.mFloatView.getX();
    }

    @Override
    public int getY() {
        return this.mFloatView.getY();
    }

    @Override
    public View getView() {
        this.mSlop = ViewConfiguration.get((Context)this.mB.mApplicationContext).getScaledTouchSlop();
        return this.mB.mView;
    }

    private void checkMoveType() {
        if (this.mB.mMoveType == 0) {
            throw new IllegalArgumentException("FloatWindow of this tag is not allowed to move!");
        }
    }

    private void initTouchEvent() {
        switch (this.mB.mMoveType) {
            case 1: {
                break;
            }
            default: {
                this.getView().setOnTouchListener(new View.OnTouchListener(){
                    float lastX;
                    float lastY;
                    float changeX;
                    float changeY;
                    int newX;
                    int newY;

                    @SuppressLint(value={"ClickableViewAccessibility"})
                    public boolean onTouch(View v, MotionEvent event) {
                        switch (event.getAction()) {
                            case 0: {
                                IFloatWindowImpl.this.downX = event.getRawX();
                                IFloatWindowImpl.this.downY = event.getRawY();
                                this.lastX = event.getRawX();
                                this.lastY = event.getRawY();
                                IFloatWindowImpl.this.cancelAnimator();
                                break;
                            }
                            case 2: {
                                this.changeX = event.getRawX() - this.lastX;
                                this.changeY = event.getRawY() - this.lastY;
                                this.newX = (int)((float)IFloatWindowImpl.this.mFloatView.getX() + this.changeX);
                                this.newY = (int)((float)IFloatWindowImpl.this.mFloatView.getY() + this.changeY);
                                if (this.newY < 0) {
                                    this.newY = 0;
                                } else if (this.newY > IFloatWindowImpl.this.screenHeight - v.getHeight() - IFloatWindowImpl.this.statusBarHeight) {
                                    this.newY = IFloatWindowImpl.this.screenHeight - v.getHeight() - IFloatWindowImpl.this.statusBarHeight;
                                }
                                IFloatWindowImpl.this.mFloatView.updateXY(this.newX, this.newY);
                                if (((IFloatWindowImpl)IFloatWindowImpl.this).mB.mViewStateListener != null) {
                                    ((IFloatWindowImpl)IFloatWindowImpl.this).mB.mViewStateListener.onPositionUpdate(this.newX, this.newY);
                                }
                                this.lastX = event.getRawX();
                                this.lastY = event.getRawY();
                                break;
                            }
                            case 1: {
                                IFloatWindowImpl.this.upX = event.getRawX();
                                IFloatWindowImpl.this.upY = event.getRawY();
                                IFloatWindowImpl.this.mClick = Math.abs(IFloatWindowImpl.this.upX - IFloatWindowImpl.this.downX) > (float)IFloatWindowImpl.this.mSlop || Math.abs(IFloatWindowImpl.this.upY - IFloatWindowImpl.this.downY) > (float)IFloatWindowImpl.this.mSlop;
                                IFloatWindowImpl.this.onActionUp(v);
                                return IFloatWindowImpl.this.mClick;
                            }
                        }
                        return false;
                    }
                });
            }
        }
    }

    private void onActionUp(View v) {
        switch (this.mB.mMoveType) {
            case 3: {
                int startX = this.mFloatView.getX();
                int endX = startX * 2 + v.getWidth() > this.screenWidth ? this.screenWidth - v.getWidth() - this.mB.mSlideRightMargin : this.mB.mSlideLeftMargin;
                this.mAnimator = ObjectAnimator.ofInt((int[])new int[]{startX, endX});
                this.mAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

                    public void onAnimationUpdate(ValueAnimator animation) {
                        int x = (Integer)animation.getAnimatedValue();
                        IFloatWindowImpl.this.mFloatView.updateX(x);
                        if (((IFloatWindowImpl)IFloatWindowImpl.this).mB.mViewStateListener != null) {
                            ((IFloatWindowImpl)IFloatWindowImpl.this).mB.mViewStateListener.onPositionUpdate(x, (int)IFloatWindowImpl.this.upY);
                        }
                    }
                });
                this.startAnimator();
                break;
            }
            case 4: {
                PropertyValuesHolder pvhX = PropertyValuesHolder.ofInt((String)"x", (int[])new int[]{this.mFloatView.getX(), this.mB.xOffset});
                PropertyValuesHolder pvhY = PropertyValuesHolder.ofInt((String)"y", (int[])new int[]{this.mFloatView.getY(), this.mB.yOffset});
                this.mAnimator = ObjectAnimator.ofPropertyValuesHolder((PropertyValuesHolder[])new PropertyValuesHolder[]{pvhX, pvhY});
                this.mAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

                    public void onAnimationUpdate(ValueAnimator animation) {
                        int x = (Integer)animation.getAnimatedValue("x");
                        int y = (Integer)animation.getAnimatedValue("y");
                        IFloatWindowImpl.this.mFloatView.updateXY(x, y);
                        if (((IFloatWindowImpl)IFloatWindowImpl.this).mB.mViewStateListener != null) {
                            ((IFloatWindowImpl)IFloatWindowImpl.this).mB.mViewStateListener.onPositionUpdate(x, y);
                        }
                    }
                });
                this.startAnimator();
                break;
            }
        }
    }

    private void startAnimator() {
        if (this.mB.mInterpolator == null) {
            if (this.mDecelerateInterpolator == null) {
                this.mDecelerateInterpolator = new DecelerateInterpolator();
            }
            this.mB.mInterpolator = this.mDecelerateInterpolator;
        }
        this.mAnimator.setInterpolator(this.mB.mInterpolator);
        this.mAnimator.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationEnd(Animator animation) {
                IFloatWindowImpl.this.mAnimator.removeAllUpdateListeners();
                IFloatWindowImpl.this.mAnimator.removeAllListeners();
                IFloatWindowImpl.this.mAnimator = null;
                if (((IFloatWindowImpl)IFloatWindowImpl.this).mB.mViewStateListener != null) {
                    ((IFloatWindowImpl)IFloatWindowImpl.this).mB.mViewStateListener.onMoveAnimEnd();
                }
            }
        });
        this.mAnimator.setDuration(this.mB.mDuration).start();
        if (this.mB.mViewStateListener != null) {
            this.mB.mViewStateListener.onMoveAnimStart();
        }
    }

    private void cancelAnimator() {
        if (this.mAnimator != null && this.mAnimator.isRunning()) {
            this.mAnimator.cancel();
        }
    }

    @Override
    public void destory() {
        if (this.mFloatLifecycle == null) {
            return;
        }
        this.mFloatLifecycle.unRegisterReceiver(this.mB.mApplicationContext);
    }
}

