/*
 * Decompiled with CFR 0.152.
 */
package com.yhao.floatwindow;

import android.content.Context;
import android.graphics.Point;
import android.graphics.Rect;
import android.view.LayoutInflater;
import android.view.View;
import android.view.WindowManager;
import java.lang.reflect.Field;

class Util {
    private static Point sPoint;
    private static int statusBarHeight;

    Util() {
    }

    static View inflate(Context applicationContext, int layoutId) {
        LayoutInflater inflate = (LayoutInflater)applicationContext.getSystemService("layout_inflater");
        return inflate.inflate(layoutId, null);
    }

    static int getScreenWidth(Context context) {
        if (sPoint == null) {
            sPoint = new Point();
            WindowManager wm = (WindowManager)context.getSystemService("window");
            wm.getDefaultDisplay().getSize(sPoint);
        }
        return Util.sPoint.x;
    }

    static int getScreenHeight(Context context) {
        if (sPoint == null) {
            sPoint = new Point();
            WindowManager wm = (WindowManager)context.getSystemService("window");
            wm.getDefaultDisplay().getSize(sPoint);
        }
        return Util.sPoint.y;
    }

    public static int getStatusBarHeight(Context mContext) {
        int statusBarHeight = Util.getStatusBarHeightByReflect(mContext);
        if (statusBarHeight == 0) {
            statusBarHeight = Util.dip2px(mContext, 30.0f);
        }
        return statusBarHeight;
    }

    public static int getStatusBarHeightByReflect(Context mContext) {
        if (statusBarHeight > 0) {
            return statusBarHeight;
        }
        try {
            Class<?> c = Class.forName("com.android.internal.R$dimen");
            Object obj = c.newInstance();
            Field field = c.getField("status_bar_height");
            int sbHeightId = Integer.parseInt(field.get(obj).toString());
            statusBarHeight = mContext.getResources().getDimensionPixelSize(sbHeightId);
        }
        catch (Exception e1) {
            e1.printStackTrace();
            statusBarHeight = 0;
        }
        return statusBarHeight;
    }

    public static int dip2px(Context mContext, float dipValue) {
        float scale = mContext.getResources().getDisplayMetrics().density;
        return (int)(dipValue * scale + 0.5f);
    }

    static boolean isViewVisible(View view) {
        return view.getGlobalVisibleRect(new Rect());
    }

    static {
        statusBarHeight = 0;
    }
}

