/*
 * Decompiled with CFR 0.152.
 */
package com.kangxin.common.byh;

import android.graphics.drawable.Drawable;
import android.text.TextUtils;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.collection.ArrayMap;
import com.kangxin.common.byh.util.VertifyDataUtil;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class ByPlatform {
    private static final String TAG = ByPlatform.class.getSimpleName();
    public static final String PLATFORM_CURRENT = "";
    public static final String PLATFORM_BY = "by";
    public static final String PLATFORM_YD = "yd";
    public static final String PLATFORM_ZR = "zr";
    public static final String PLATFORM_HT = "ht";
    public static final String PLATFORM_NDE = "nde";
    public static final String PLATFORM_ZDY = "zdy";
    public static final String PLATFORM_LYT = "lyt";
    public static final String PLATFORM_YC = "yc";

    public static String getCurrentPlatform() {
        return PLATFORM_CURRENT;
    }

    @NonNull
    public static <T> T getResources(Map<String, T> map) {
        T t = map.get(ByPlatform.getCurrentPlatform());
        if (t == null) {
            T byt = map.get(PLATFORM_BY);
            return byt;
        }
        return t;
    }

    @NonNull
    public static ResourcesMap createResources() {
        return new ResourcesMap();
    }

    @NonNull
    public static Callback createCallback() {
        return new Callback();
    }

    public static boolean hasZr() {
        return TextUtils.equals((CharSequence)ByPlatform.getCurrentPlatform(), (CharSequence)PLATFORM_ZR);
    }

    public static boolean hasHt() {
        return TextUtils.equals((CharSequence)ByPlatform.getCurrentPlatform(), (CharSequence)PLATFORM_HT);
    }

    public static boolean hasBy() {
        return TextUtils.equals((CharSequence)ByPlatform.getCurrentPlatform(), (CharSequence)PLATFORM_BY);
    }

    public static boolean hasNde() {
        return TextUtils.equals((CharSequence)ByPlatform.getCurrentPlatform(), (CharSequence)PLATFORM_NDE);
    }

    public static boolean hasZdy() {
        return TextUtils.equals((CharSequence)ByPlatform.getCurrentPlatform(), (CharSequence)PLATFORM_ZDY);
    }

    public static boolean hasYd() {
        return TextUtils.equals((CharSequence)ByPlatform.getCurrentPlatform(), (CharSequence)PLATFORM_YD);
    }

    public static boolean hasLyt() {
        return TextUtils.equals((CharSequence)ByPlatform.getCurrentPlatform(), (CharSequence)PLATFORM_LYT);
    }

    public static boolean hasYc() {
        return TextUtils.equals((CharSequence)ByPlatform.getCurrentPlatform(), (CharSequence)PLATFORM_YC);
    }

    private static void checkPlatform() {
        if (!(ByPlatform.hasBy() || ByPlatform.hasZr() || ByPlatform.hasHt() || ByPlatform.hasNde() || ByPlatform.hasZdy() || ByPlatform.hasYd())) {
            throw new NullPointerException("Platform == null");
        }
    }

    public static List<String> getHtAppCode() {
        return Collections.singletonList("HYT");
    }

    public static List<String> getLYAppCode() {
        return Collections.singletonList("LYCITYYS");
    }

    public static boolean hasLoginHt() {
        return ByPlatform.getHtAppCode().contains(VertifyDataUtil.getInstance().getAppCode());
    }

    public static class ResourcesMap {
        private Map<String, Object> data = new ArrayMap();

        ResourcesMap() {
        }

        public ResourcesMap add(String platform, @NonNull Object data) {
            this.data.put(platform, data);
            return this;
        }

        public ResourcesMap addHt(@NonNull Object data) {
            this.data.put(ByPlatform.PLATFORM_HT, data);
            return this;
        }

        public ResourcesMap addZr(@NonNull Object data) {
            this.data.put(ByPlatform.PLATFORM_ZR, data);
            return this;
        }

        public ResourcesMap addBy(@NonNull Object data) {
            this.data.put(ByPlatform.PLATFORM_BY, data);
            return this;
        }

        public ResourcesMap addZdy(@NonNull Object data) {
            this.data.put(ByPlatform.PLATFORM_ZDY, data);
            return this;
        }

        public ResourcesMap addYd(@NonNull Object data) {
            this.data.put(ByPlatform.PLATFORM_YD, data);
            return this;
        }

        public ResourcesMap addNde(@NonNull Object data) {
            this.data.put(ByPlatform.PLATFORM_NDE, data);
            return this;
        }

        public ResourcesMap addLyt(@NonNull Object data) {
            this.data.put(ByPlatform.PLATFORM_LYT, data);
            return this;
        }

        public ResourcesMap addYc(@NonNull Object data) {
            this.data.put(ByPlatform.PLATFORM_YC, data);
            return this;
        }

        public ResourcesMap add(Map<String, Object> map) {
            this.data = map;
            return this;
        }

        @NonNull
        private Object resource() {
            Object resources = ByPlatform.getResources(this.data);
            this.data.clear();
            this.data = null;
            return resources;
        }

        @NonNull
        private <T> T generic() {
            return (T)this.resource();
        }

        public int intValue() {
            return (Integer)this.generic();
        }

        @NonNull
        public String stringValue() {
            return (String)this.generic();
        }

        @NonNull
        public Drawable drawableValue() {
            return (Drawable)this.generic();
        }
    }

    public static class Callback {
        @Nullable
        private PlatformByCallback platformByCallback;
        @Nullable
        private PlatformHtCallback platformHtCallback;
        @Nullable
        private PlatformZrCallback platformZrCallback;
        @Nullable
        private PlatformNdeCallback platformNdeCallback;
        private PlatformYdCallback platformYdCallback;
        @Nullable
        private PlatformZdyCallback platformZdyCallback;
        @Nullable
        private PlatformOtherCallback platformOtherCallback;

        public Callback addBy(@Nullable PlatformByCallback callback) {
            this.platformByCallback = callback;
            return this;
        }

        public Callback addHt(@Nullable PlatformHtCallback callback) {
            this.platformHtCallback = callback;
            return this;
        }

        public Callback addZr(@Nullable PlatformZrCallback callback) {
            this.platformZrCallback = callback;
            return this;
        }

        public Callback addZdy(@Nullable PlatformZdyCallback callback) {
            this.platformZdyCallback = callback;
            return this;
        }

        public Callback addYd(@Nullable PlatformYdCallback callback) {
            this.platformYdCallback = callback;
            return this;
        }

        public Callback addNde(@Nullable PlatformNdeCallback callback) {
            this.platformNdeCallback = callback;
            return this;
        }

        public Callback addOther(@Nullable PlatformOtherCallback callback) {
            this.platformOtherCallback = callback;
            return this;
        }

        public void callback() {
            PlatformCallback platformCallback = null;
            if (ByPlatform.hasBy()) {
                platformCallback = this.platformByCallback;
            } else if (ByPlatform.hasZr()) {
                platformCallback = this.platformZrCallback;
            } else if (ByPlatform.hasHt()) {
                platformCallback = this.platformHtCallback;
            } else if (ByPlatform.hasZdy()) {
                platformCallback = this.platformZdyCallback;
            } else if (ByPlatform.hasNde()) {
                platformCallback = this.platformNdeCallback;
            } else if (ByPlatform.hasYd()) {
                platformCallback = this.platformYdCallback;
            }
            if (platformCallback == null) {
                if (this.platformOtherCallback != null) {
                    this.platformOtherCallback.onFirstCallback(ByPlatform.getCurrentPlatform());
                    this.platformOtherCallback.otherCallback();
                    this.platformOtherCallback.onLastCallback(ByPlatform.getCurrentPlatform());
                    Log.i((String)TAG, (String)"platformOtherCallback");
                } else {
                    Log.e((String)TAG, (String)"platformOtherCallback == null  & platformCallback == null");
                }
                this.resetCallback();
                return;
            }
            platformCallback.onFirstCallback(ByPlatform.getCurrentPlatform());
            if (ByPlatform.hasBy()) {
                platformCallback.byCallback();
            } else if (ByPlatform.hasZr()) {
                ((PlatformZrCallback)platformCallback).zrCallback();
            } else if (ByPlatform.hasHt()) {
                ((PlatformHtCallback)platformCallback).htCallback();
            } else if (ByPlatform.hasNde()) {
                ((PlatformNdeCallback)platformCallback).ndeCallback();
            } else if (ByPlatform.hasZdy()) {
                ((PlatformZdyCallback)platformCallback).zdyCallback();
            } else if (ByPlatform.hasYd()) {
                ((PlatformYdCallback)platformCallback).ydCallback();
            }
            platformCallback.onLastCallback(ByPlatform.getCurrentPlatform());
            this.resetCallback();
        }

        private void resetCallback() {
            this.platformByCallback = null;
            this.platformZrCallback = null;
            this.platformHtCallback = null;
            this.platformZdyCallback = null;
            this.platformNdeCallback = null;
            this.platformYdCallback = null;
            this.platformOtherCallback = null;
        }
    }

    public static interface PlatformOtherCallback
    extends PlatformCallback {
        public void otherCallback();
    }

    public static interface PlatformZdyCallback
    extends PlatformCallback {
        public void zdyCallback();
    }

    public static interface PlatformNdeCallback
    extends PlatformCallback {
        public void ndeCallback();
    }

    public static interface PlatformYdCallback
    extends PlatformCallback {
        public void ydCallback();
    }

    public static interface PlatformZrCallback
    extends PlatformCallback {
        public void zrCallback();
    }

    public static interface PlatformHtCallback
    extends PlatformCallback {
        public void htCallback();
    }

    public static interface PlatformByCallback
    extends PlatformCallback {
        public void byCallback();
    }

    public static interface PlatformCallback {
        default public void onFirstCallback(String platform) {
        }

        default public void onLastCallback(String platform) {
        }
    }
}

