/*
 * Decompiled with CFR 0.152.
 */
package com.kangxin.common.byh;

import android.content.Context;
import androidx.annotation.NonNull;
import com.kangxin.common.byh.util.VertifyDataUtil;
import com.kangxin.doctor.libdata.R;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import okhttp3.HttpUrl;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;

public class HttpUrlIntercepter
implements Interceptor {
    private static final String TAG = "HttpUrlIntercepter";
    private Context context;
    private static final String POST = "POST";

    public HttpUrlIntercepter(Context context) {
        this.context = context;
    }

    public Response intercept(Interceptor.Chain chain) throws IOException {
        if (this.isNativeCloud(chain)) {
            Request newRequest = this.nativeCloudRequest(chain.request(), chain.request().url());
            return chain.proceed(newRequest);
        }
        if (this.getUrl(chain).contains("/ehospital-doctor/queryStandDeptByOrganId")) {
            return chain.proceed(chain.request());
        }
        Request request = this.cloudRequest(chain.request(), chain.request().url());
        return chain.proceed(request);
    }

    private Request cloudRequest(Request request, HttpUrl url) {
        RequestBody requestBody = request.body();
        Request.Builder builder = new Request.Builder();
        HttpUrl.Builder httpUrl = new HttpUrl.Builder();
        httpUrl.host(url.host());
        httpUrl.port(url.port());
        httpUrl.scheme(url.scheme());
        int size = url.pathSegments().size();
        if (url.pathSegments() != null && url.pathSegments().size() > 0) {
            String string2 = (String)url.pathSegments().get(0);
        }
        for (int i = 0; i < size; ++i) {
            httpUrl.addPathSegment((String)url.pathSegments().get(i));
        }
        httpUrl.query(url.query());
        HttpUrl newHttpUrl = httpUrl.build();
        String method = request.method();
        if (POST.equals(method)) {
            return builder.headers(request.headers()).post(requestBody).url(newHttpUrl).build();
        }
        if (requestBody != null) {
            return builder.headers(request.headers()).post(requestBody).get().url(newHttpUrl).build();
        }
        return builder.headers(request.headers()).get().url(newHttpUrl).build();
    }

    private boolean isNativeCloud(Interceptor.Chain chain) {
        String[] stringArray = this.context.getResources().getStringArray(R.array.commbyh_native_cloud_router_table);
        List<String> nativeCloudRouterTables = Arrays.asList(stringArray);
        Request request = chain.request();
        HttpUrl url = request.url();
        List requestSegmentPath = url.pathSegments();
        String realPath = "";
        for (int i = 0; i < requestSegmentPath.size(); ++i) {
            realPath = realPath + "/" + (String)requestSegmentPath.get(i);
        }
        return nativeCloudRouterTables.contains(realPath);
    }

    private String getUrl(Interceptor.Chain chain) {
        Request request = chain.request();
        HttpUrl url = request.url();
        List requestSegmentPath = url.pathSegments();
        String realPath = "";
        for (int i = 0; i < requestSegmentPath.size(); ++i) {
            realPath = realPath + "/" + (String)requestSegmentPath.get(i);
        }
        return realPath;
    }

    @NonNull
    private Request nativeCloudRequest(Request request, HttpUrl url) {
        RequestBody requestBody = request.body();
        Request.Builder builder = new Request.Builder();
        HttpUrl.Builder httpUrl = new HttpUrl.Builder();
        httpUrl.host(url.host());
        httpUrl.port(url.port());
        httpUrl.scheme(url.scheme());
        int size = url.pathSegments().size();
        httpUrl.addPathSegment(VertifyDataUtil.getInstance(this.context).getOpenCode());
        for (int i = 0; i < size; ++i) {
            httpUrl.addPathSegment((String)url.pathSegments().get(i));
        }
        HttpUrl newHttpUrl = httpUrl.build();
        return builder.headers(request.headers()).post(requestBody).url(newHttpUrl).build();
    }
}

