/*
 * Decompiled with CFR 0.152.
 */
package com.kangxin.common.byh.db.entity;

import android.text.TextUtils;
import androidx.annotation.NonNull;
import androidx.room.ColumnInfo;
import androidx.room.Entity;
import androidx.room.Ignore;
import androidx.room.PrimaryKey;
import com.blankj.utilcode.util.StringUtils;
import com.google.gson.Gson;
import com.kangxin.common.byh.entity.v2.PushOrderEntity;
import com.umeng.message.entity.UMessage;
import java.io.Serializable;
import java.util.Map;

@Entity(tableName="push2")
public class ByPushEntity
implements Serializable {
    @PrimaryKey
    @NonNull
    String pushKey;
    @ColumnInfo(name="push_code")
    String pushCode;
    @Ignore
    String followupPlanOrderDetailId;
    @Ignore
    String admId;
    @Ignore
    String formName;
    @Ignore
    String id;
    @Ignore
    String actionCode;
    @Ignore
    String createTime;
    @Ignore
    String notifyType;
    @Ignore
    String sdkAccount;
    @ColumnInfo(name="business_key")
    Long businessKey;
    @ColumnInfo(name="business_type")
    String businessType;
    @ColumnInfo(name="business_extend")
    String businessExtend;
    @Ignore
    String userId;
    @ColumnInfo(name="content")
    String content;
    @ColumnInfo(name="title")
    String title;
    @ColumnInfo(name="is_read")
    Integer isRead = 0;

    public static ByPushEntity parse(UMessage msg) {
        ByPushEntity entity = new ByPushEntity();
        entity.setPushKey(msg.msg_id);
        Map extra = msg.extra;
        if (extra != null) {
            String result = new Gson().toJson((Object)extra);
            PushOrderEntity pushOrderEntity = (PushOrderEntity)new Gson().fromJson(result, PushOrderEntity.class);
            entity.pushCode = pushOrderEntity.getPushCode();
            entity.pushKey = msg.msg_id;
            String type = (String)extra.get("businessCode");
            entity.businessType = null != type && type.equals("hzbd") && pushOrderEntity.getPushCode().equals("JKGL") ? "hzbd" : pushOrderEntity.getPushCode();
            entity.businessExtend = pushOrderEntity.getOrderViewId();
            entity.sdkAccount = (String)extra.get("sdkAccount");
            entity.followupPlanOrderDetailId = (String)extra.get("followupPlanOrderDetailId");
            entity.formName = (String)extra.get("formName");
            entity.actionCode = (String)extra.get("actionCode");
            entity.id = (String)extra.get("id");
            entity.admId = (String)extra.get("admId");
            String userId = (String)extra.get("userId");
            if (!TextUtils.isEmpty((CharSequence)userId)) {
                entity.userId = userId;
            }
            if (StringUtils.isEmpty((CharSequence)entity.pushCode)) {
                entity.pushCode = (String)extra.get("businessCode");
                entity.businessType = (String)extra.get("businessCode");
                entity.businessExtend = (String)extra.get("orderId");
                entity.notifyType = (String)extra.get("notifyType");
            }
        }
        entity.content = msg.text;
        entity.title = msg.ticker;
        return entity;
    }

    public String getSdkAccount() {
        return this.sdkAccount;
    }

    public void setSdkAccount(String sdkAccount) {
        this.sdkAccount = sdkAccount;
    }

    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public String getNotifyType() {
        return this.notifyType;
    }

    public void setNotifyType(String notifyType) {
        this.notifyType = notifyType;
    }

    public String getPushKey() {
        return this.pushKey;
    }

    public void setPushKey(String pushKey) {
        this.pushKey = pushKey;
    }

    public String getPushCode() {
        return this.pushCode;
    }

    public void setPushCode(String pushCode) {
        this.pushCode = pushCode;
    }

    public String getCreateTime() {
        return this.createTime;
    }

    public void setCreateTime(String createTime) {
        this.createTime = createTime;
    }

    public Long getBusinessKey() {
        return this.businessKey;
    }

    public void setBusinessKey(Long businessKey) {
        this.businessKey = businessKey;
    }

    public String getBusinessType() {
        return this.businessType;
    }

    public void setBusinessType(String businessType) {
        this.businessType = businessType;
    }

    public String getBusinessExtend() {
        return this.businessExtend;
    }

    public void setBusinessExtend(String businessExtend) {
        this.businessExtend = businessExtend;
    }

    public String getContent() {
        return this.content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public Integer getIsRead() {
        return this.isRead;
    }

    public void setIsRead(Integer isRead) {
        this.isRead = isRead;
    }

    public String getFollowupPlanOrderDetailId() {
        return this.followupPlanOrderDetailId;
    }

    public void setFollowupPlanOrderDetailId(String followupPlanOrderDetailId) {
        this.followupPlanOrderDetailId = followupPlanOrderDetailId;
    }

    public String getFormName() {
        return this.formName;
    }

    public void setFormName(String formName) {
        this.formName = formName;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id2) {
        this.id = id2;
    }

    public String getActionCode() {
        return this.actionCode;
    }

    public void setActionCode(String actionCode) {
        this.actionCode = actionCode;
    }

    public String getAdmId() {
        return this.admId;
    }

    public void setAdmId(String admId) {
        this.admId = admId;
    }

    public String toString() {
        return "ByPushEntity{pushKey='" + this.pushKey + '\'' + ", pushCode='" + this.pushCode + '\'' + ", followupPlanOrderDetailId='" + this.followupPlanOrderDetailId + '\'' + ", admId='" + this.admId + '\'' + ", formName='" + this.formName + '\'' + ", id='" + this.id + '\'' + ", actionCode='" + this.actionCode + '\'' + ", createTime='" + this.createTime + '\'' + ", notifyType='" + this.notifyType + '\'' + ", sdkAccount='" + this.sdkAccount + '\'' + ", businessKey=" + this.businessKey + ", businessType='" + this.businessType + '\'' + ", businessExtend='" + this.businessExtend + '\'' + ", userId='" + this.userId + '\'' + ", content='" + this.content + '\'' + ", title='" + this.title + '\'' + ", isRead=" + this.isRead + '}';
    }
}

