/*
 * Decompiled with CFR 0.152.
 */
package com.kangxin.common.byh.db.impl;

import com.kangxin.common.base.ResponseBody;
import com.kangxin.common.base.mvp.BaseModel;
import com.kangxin.common.byh.api.PushApi;
import com.kangxin.common.byh.db.DB;
import com.kangxin.common.byh.db.IPushModule;
import com.kangxin.common.byh.db.entity.ByPushEntity;
import com.kangxin.common.util.SchedulesSwitch;
import io.reactivex.Flowable;
import io.reactivex.Observable;
import io.reactivex.ObservableEmitter;
import io.reactivex.ObservableOnSubscribe;
import io.reactivex.android.schedulers.AndroidSchedulers;
import io.reactivex.schedulers.Schedulers;
import java.util.List;

public class PushModule
extends BaseModel
implements IPushModule {
    @Override
    public Flowable<List<ByPushEntity>> getPushAllList() {
        return DB.getInstance().pushDao().getPushs().subscribeOn(Schedulers.io()).observeOn(AndroidSchedulers.mainThread());
    }

    @Override
    public Flowable<List<ByPushEntity>> getUnreadPushList() {
        return DB.getInstance().pushDao().getUnreadPushList().subscribeOn(Schedulers.io()).observeOn(AndroidSchedulers.mainThread());
    }

    @Override
    public Flowable<List<ByPushEntity>> getPushListByUnBusType(String ... unBusType) {
        return DB.getInstance().pushDao().getPushsUnByBusinessType(unBusType).subscribeOn(Schedulers.io()).observeOn(AndroidSchedulers.mainThread());
    }

    @Override
    public Flowable<List<ByPushEntity>> getPushListByBusType(String busType) {
        return DB.getInstance().pushDao().getPushsByBusinessType(busType).subscribeOn(Schedulers.io()).observeOn(AndroidSchedulers.mainThread());
    }

    @Override
    public Observable readPush(final String pushKey) {
        return Observable.create((ObservableOnSubscribe)new ObservableOnSubscribe<Object>(){

            public void subscribe(ObservableEmitter<Object> emitter) throws Exception {
                DB.getInstance().pushDao().readPushByPushKey(pushKey);
                emitter.onNext(new Object());
            }
        });
    }

    @Override
    public Observable readPushs() {
        return Observable.create((ObservableOnSubscribe)new ObservableOnSubscribe<Object>(){

            public void subscribe(ObservableEmitter<Object> emitter) throws Exception {
                DB.getInstance().pushDao().readAllPush();
                emitter.onNext(new Object());
            }
        }).compose(SchedulesSwitch.applySchedulers());
    }

    @Override
    public Observable readPushByBusType(final String ... busType) {
        return Observable.create((ObservableOnSubscribe)new ObservableOnSubscribe<Object>(){

            public void subscribe(ObservableEmitter<Object> emitter) throws Exception {
                DB.getInstance().pushDao().readAllPush(busType);
                emitter.onNext(new Object());
            }
        }).compose(SchedulesSwitch.applySchedulers());
    }

    @Override
    public Observable readPushUnbussType(final String ... busType) {
        return Observable.create((ObservableOnSubscribe)new ObservableOnSubscribe<Object>(){

            public void subscribe(ObservableEmitter<Object> emitter) throws Exception {
                DB.getInstance().pushDao().readPushUnbussType(busType);
                emitter.onNext(new Object());
            }
        }).compose(SchedulesSwitch.applySchedulers());
    }

    @Override
    public Observable clearPush() {
        return Observable.create((ObservableOnSubscribe)new ObservableOnSubscribe<Object>(){

            public void subscribe(ObservableEmitter<Object> emitter) throws Exception {
                DB.getInstance().pushDao().clearPush();
                emitter.onNext(new Object());
            }
        }).compose(SchedulesSwitch.applySchedulers());
    }

    @Override
    public Observable<ResponseBody<List<ByPushEntity>>> getPushEntitiesByTypeOnline(long userId, int type) {
        return ((PushApi)this.createApi2(PushApi.class)).getPushEntitiesByTypeOnline(userId, type).compose(SchedulesSwitch.applySchedulers());
    }

    @Override
    public Observable<ResponseBody> readPushByBusTypeOnline(long userId, int userType, String pushType) {
        return ((PushApi)this.createApi2(PushApi.class)).readPushByBusTypeOnline(userId, userType, pushType).compose(SchedulesSwitch.applySchedulers());
    }
}

