/*
 * Decompiled with CFR 0.152.
 */
package com.kangxin.common.byh.db.impl;

import android.content.Context;
import android.util.Log;
import com.alibaba.android.arouter.launcher.ARouter;
import com.blankj.utilcode.util.LogUtils;
import com.kangxin.common.base.ResponseBody;
import com.kangxin.common.byh.db.IPushModule;
import com.kangxin.common.byh.db.IPushPresenter;
import com.kangxin.common.byh.db.entity.ByPushEntity;
import com.kangxin.common.byh.db.impl.PushModule;
import com.kangxin.common.byh.entity.UpdateDataEntity;
import com.kangxin.common.byh.event.ByPushListEvent;
import com.kangxin.common.byh.inter.IPushSaveCallback;
import com.kangxin.common.byh.util.VertifyDataUtil;
import com.kangxin.common.rx.SampleObserver;
import io.reactivex.Observer;
import java.util.List;
import org.greenrobot.eventbus.EventBus;

public class PushPresenter
implements IPushPresenter {
    private static final String TAG = "PushPresenter";
    private IPushModule pushModule = new PushModule();

    @Override
    public void getPushAllList() {
        this.pushModule.getPushAllList().subscribe(byPushEntities -> EventBus.getDefault().post((Object)new ByPushListEvent("1", (List<ByPushEntity>)byPushEntities)));
    }

    @Override
    public void getUnreadPushList() {
        this.pushModule.getUnreadPushList().subscribe(byPushEntities -> EventBus.getDefault().post((Object)new ByPushListEvent("2", (List<ByPushEntity>)byPushEntities)));
    }

    @Override
    public void getPushListByUnBusType(String ... busType) {
        this.pushModule.getPushListByUnBusType(busType).subscribe(byPushEntities -> EventBus.getDefault().post((Object)new ByPushListEvent((List<ByPushEntity>)byPushEntities, busType)));
    }

    @Override
    public void getPushListByBusType(String busType) {
        this.pushModule.getPushListByBusType(busType).subscribe(byPushEntities -> {
            Log.i((String)TAG, (String)("\u83b7\u53d6\u5217\u8868\u6210\u529f" + busType + "\u957f\u5ea6=" + byPushEntities.size()));
            EventBus.getDefault().post((Object)new ByPushListEvent(busType, (List<ByPushEntity>)byPushEntities));
        });
    }

    @Override
    public void readPush(String pushKey) {
        this.pushModule.readPush(pushKey).subscribe(o -> Log.i((String)TAG, (String)"\u9605\u8bfb\u6210\u529f"));
    }

    @Override
    public void readPushs() {
        this.pushModule.readPushs().subscribe(o -> Log.i((String)TAG, (String)"\u9605\u8bfb\u6240\u6709\u6210\u529f"));
    }

    @Override
    public void readPushByBusType(String ... busType) {
        this.pushModule.readPushByBusType(busType).subscribe(o -> {
            Log.i((String)TAG, (String)("\u9605\u8bfb\u6570\u636e\u6210\u529f" + busType));
            EventBus.getDefault().post((Object)new UpdateDataEntity());
        });
    }

    @Override
    public void readPushUnbussType(String ... busType) {
        this.pushModule.readPushUnbussType(busType).subscribe(o -> {
            Log.i((String)TAG, (String)("\u901a\u8fc7\u7c7b\u578b\u9605\u8bfb\u6210\u529f" + busType));
            EventBus.getDefault().post((Object)new UpdateDataEntity());
        });
    }

    @Override
    public void clearPush() {
        this.pushModule.clearPush().subscribe(o -> Log.i((String)TAG, (String)"\u6e05\u7a7a\u6210\u529f"));
    }

    @Override
    public void getPushEntitiesByTypeOnline(final Context context, long userId, int userType) {
        this.pushModule.getPushEntitiesByTypeOnline(userId, userType).subscribe((Observer)new SampleObserver<ResponseBody<List<ByPushEntity>>>(){

            public void onNext(ResponseBody<List<ByPushEntity>> t) {
                List result;
                if (t.getCode() == 200 && (result = (List)t.getResult()) != null && result.size() > 0) {
                    for (ByPushEntity entity : result) {
                        IPushSaveCallback navigation = (IPushSaveCallback)ARouter.getInstance().navigation(IPushSaveCallback.class);
                        navigation.savePushEntity(context, entity);
                    }
                }
            }
        });
    }

    @Override
    public void readPushEntitiesByTypeOnline(Context context, String pushType) {
        long loginUserId = VertifyDataUtil.getInstance(context).getLoginUserId();
        this.pushModule.readPushByBusTypeOnline(loginUserId, 3, pushType).subscribe((Observer)new SampleObserver<ResponseBody>(){

            public void onNext(ResponseBody t) {
                if (t.getCode() == 200) {
                    LogUtils.i((Object[])new Object[]{"\u9605\u8bfb\u7f51\u7edc\u4e0a\u7684\u6d88\u606f\u6210\u529f"});
                }
            }
        });
    }
}

