/*
 * Decompiled with CFR 0.152.
 */
package com.kangxin.common.byh.event;

import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.os.Bundle;
import android.os.Handler;
import com.kangxin.common.byh.util.BadgeUtil;
import com.kangxin.util.common.LogUtils;
import java.lang.ref.WeakReference;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public class ForegroundCallbacks
implements Application.ActivityLifecycleCallbacks {
    public static final long CHECK_DELAY = 500L;
    private static ForegroundCallbacks instance;
    private boolean foreground = false;
    private boolean paused = true;
    private Handler handler = new Handler();
    private List<Listener> listeners = new CopyOnWriteArrayList<Listener>();
    private Runnable check;
    private WeakReference<Activity> foreceActvity;

    public static ForegroundCallbacks init(Application application) {
        if (instance == null) {
            instance = new ForegroundCallbacks();
            application.registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)instance);
        }
        return instance;
    }

    public static ForegroundCallbacks get(Application application) {
        if (instance == null) {
            ForegroundCallbacks.init(application);
        }
        return instance;
    }

    public static ForegroundCallbacks get(Context ctx) {
        if (instance == null) {
            Context appCtx = ctx.getApplicationContext();
            if (appCtx instanceof Application) {
                ForegroundCallbacks.init((Application)appCtx);
            }
            throw new IllegalStateException("Foreground is not initialised and cannot obtain the Application object");
        }
        return instance;
    }

    public static ForegroundCallbacks get() {
        if (instance == null) {
            throw new IllegalStateException("Foreground is not initialised - invoke at least once with parameterised init/get");
        }
        return instance;
    }

    public boolean isForeground() {
        return this.foreground;
    }

    public boolean isBackground() {
        return !this.foreground;
    }

    public void addListener(Listener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(Listener listener) {
        this.listeners.remove(listener);
    }

    public void onActivityResumed(Activity activity) {
        this.paused = false;
        boolean wasBackground = !this.foreground;
        this.foreground = true;
        this.foreceActvity = new WeakReference<Activity>(activity);
        if (this.check != null) {
            this.handler.removeCallbacks(this.check);
        }
        if (wasBackground) {
            LogUtils.d((Object)"went foreground");
            for (Listener l : this.listeners) {
                try {
                    l.onBecameForeground();
                }
                catch (Exception exc) {
                    LogUtils.d((Object)("Listener threw exception!" + exc.getMessage()));
                }
            }
        } else {
            LogUtils.d((Object)"still foreground");
        }
    }

    public void onActivityPaused(Activity activity) {
        this.paused = true;
        if (this.check != null) {
            this.handler.removeCallbacks(this.check);
        }
        this.check = new Runnable(){

            @Override
            public void run() {
                if (ForegroundCallbacks.this.foreground && ForegroundCallbacks.this.paused) {
                    ForegroundCallbacks.this.foreground = false;
                    LogUtils.d((Object)"went background");
                    BadgeUtil.showBadgeRed();
                    for (Listener l : ForegroundCallbacks.this.listeners) {
                        try {
                            l.onBecameBackground();
                        }
                        catch (Exception exc) {
                            LogUtils.d((Object)("Listener threw exception!" + exc.getMessage()));
                        }
                    }
                } else {
                    LogUtils.d((Object)"still foreground");
                }
            }
        };
        this.handler.postDelayed(this.check, 500L);
    }

    public void onActivityCreated(Activity activity, Bundle savedInstanceState) {
        this.foreceActvity = new WeakReference<Activity>(activity);
    }

    public void onActivityStarted(Activity activity) {
    }

    public void onActivityStopped(Activity activity) {
    }

    public void onActivitySaveInstanceState(Activity activity, Bundle outState) {
    }

    public void onActivityDestroyed(Activity activity) {
    }

    public Activity getForceActivity() {
        if (this.foreceActvity != null) {
            return (Activity)this.foreceActvity.get();
        }
        return null;
    }

    public static interface Listener {
        public void onBecameForeground();

        public void onBecameBackground();
    }
}

