/*
 * Decompiled with CFR 0.152.
 */
package com.kangxin.common.byh.help;

import android.animation.Animator;
import android.content.Context;
import android.graphics.Color;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;
import androidx.annotation.Nullable;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import com.blankj.utilcode.util.ReflectUtils;
import com.blankj.utilcode.util.ScreenUtils;
import com.blankj.utilcode.util.ToastUtils;
import com.chad.library.adapter.base.BaseQuickAdapter;
import com.chad.library.adapter.base.BaseViewHolder;
import com.kangxin.common.byh.inter.DouRunnable;
import com.kangxin.doctor.libdata.R;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import per.goweii.anylayer.AnimatorHelper;
import per.goweii.anylayer.AnyLayer;
import per.goweii.anylayer.DialogLayer;
import per.goweii.anylayer.Layer;

public class ComBottomListDialogHelper<T> {
    Context mContext;
    String title;
    List<T> dataList;
    String filed;
    DouRunnable<T> clickData;
    int position = -1;

    private ComBottomListDialogHelper(Context mContext) {
        this.mContext = mContext;
    }

    public static <T> ComBottomListDialogHelper<T> with(Context mContext) {
        return new ComBottomListDialogHelper<T>(mContext);
    }

    public ComBottomListDialogHelper<T> bindData(List<T> dataList, String field, DouRunnable<T> clickData) {
        this.dataList = dataList;
        this.filed = field;
        this.clickData = clickData;
        if (this.dataList == null) {
            this.dataList = new ArrayList<T>();
        }
        return this;
    }

    public ComBottomListDialogHelper<T> bindData(List<T> dataList, DouRunnable<T> clickData) {
        if (dataList == null) {
            this.dataList = new ArrayList<T>();
            return this;
        }
        if (dataList.size() == 0) {
            return this;
        }
        if (dataList.get(0).getClass() != Map.Entry.class && !Map.Entry.class.isAssignableFrom(dataList.get(0).getClass())) {
            return this;
        }
        this.dataList = dataList;
        this.filed = "map";
        this.clickData = clickData;
        return this;
    }

    public ComBottomListDialogHelper<T> bindTitle(String title) {
        this.title = title;
        return this;
    }

    public void show() {
        AnyLayer.dialog((Context)this.mContext).gravity(80).contentView(R.layout.bottom_team_dialog_layout).backgroundDimAmount(0.6f).contentAnimator(new Layer.AnimatorCreator(){

            public Animator createInAnimator(View target) {
                return AnimatorHelper.createBottomInAnim((View)target);
            }

            public Animator createOutAnimator(View target) {
                return AnimatorHelper.createBottomOutAnim((View)target);
            }
        }).bindData(new Layer.DataBinder(){

            public void bindData(Layer layer) {
                DialogLayer l = (DialogLayer)layer;
                l.removeSoftInput();
                if (ComBottomListDialogHelper.this.dataList.size() == 0 || TextUtils.isEmpty((CharSequence)ComBottomListDialogHelper.this.filed)) {
                    return;
                }
                final Adapter adapter = new Adapter(ComBottomListDialogHelper.this.creatStrList());
                RecyclerView mRv = (RecyclerView)layer.getView(R.id.mRv);
                mRv.setAdapter((RecyclerView.Adapter)adapter);
                mRv.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager(ComBottomListDialogHelper.this.mContext));
                mRv.setHasFixedSize(true);
                ComBottomListDialogHelper.this.autoAdjustHeight(mRv);
                adapter.setOnItemClickListener(new BaseQuickAdapter.OnItemClickListener(){

                    public void onItemClick(BaseQuickAdapter adapter_, View view, int pos) {
                        if (ComBottomListDialogHelper.this.position != -1) {
                            ((Data)adapter.getData().get((int)ComBottomListDialogHelper.this.position)).isSelect = false;
                            adapter.notifyItemChanged(ComBottomListDialogHelper.this.position);
                        }
                        ((Data)adapter.getData().get((int)pos)).isSelect = true;
                        ComBottomListDialogHelper.this.position = pos;
                        adapter.notifyItemChanged(ComBottomListDialogHelper.this.position);
                    }
                });
                ((TextView)layer.getView(R.id.title)).setText((CharSequence)ComBottomListDialogHelper.this.title);
            }
        }).onClick(new Layer.OnClickListener(){

            public void onClick(Layer layer, View v) {
                if (ComBottomListDialogHelper.this.position == -1) {
                    ToastUtils.showShort((int)R.string.commbyh_qingxuanze);
                    return;
                }
                if (ComBottomListDialogHelper.this.clickData != null) {
                    ComBottomListDialogHelper.this.clickData.runnable(ComBottomListDialogHelper.this.dataList.get(ComBottomListDialogHelper.this.position), ComBottomListDialogHelper.this.position);
                }
                layer.dismiss();
            }
        }, new int[]{R.id.ok}).onClickToDismiss(new int[]{R.id.cancel}).show();
    }

    private void autoAdjustHeight(final RecyclerView mRv) {
        mRv.post(new Runnable(){

            @Override
            public void run() {
                if (mRv.getMeasuredHeight() > ScreenUtils.getScreenHeight() / 2) {
                    ViewGroup.LayoutParams params = mRv.getLayoutParams();
                    params.height = mRv.getMeasuredHeight() / 2;
                    mRv.setLayoutParams(params);
                }
            }
        });
    }

    private List<Data> creatStrList() {
        ArrayList<Data> strList = new ArrayList<Data>();
        switch (this.filed) {
            case "map": {
                for (T item : this.dataList) {
                    Map.Entry entry = (Map.Entry)item;
                    strList.add(new Data(entry.getKey().toString(), false));
                }
                break;
            }
            default: {
                for (T item : this.dataList) {
                    strList.add(new Data(ReflectUtils.reflect(item).field(this.filed).toString(), false));
                }
            }
        }
        return strList;
    }

    public static class Data {
        String content;
        boolean isSelect;

        public String getContent() {
            return this.content;
        }

        public Data setContent(String content) {
            this.content = content;
            return this;
        }

        public boolean isSelect() {
            return this.isSelect;
        }

        public Data setSelect(boolean select) {
            this.isSelect = select;
            return this;
        }

        public Data(String content, boolean isSelect) {
            this.content = content;
            this.isSelect = isSelect;
        }
    }

    private static class Adapter
    extends BaseQuickAdapter<Data, BaseViewHolder> {
        public Adapter(@Nullable List<Data> data) {
            super(R.layout.com_bottom_autoheihgt_list_dialog, data);
        }

        protected void convert(BaseViewHolder helper, Data item) {
            helper.setText(R.id.strId, (CharSequence)item.getContent());
            if (item.isSelect) {
                helper.setTextColor(R.id.strId, Color.parseColor((String)"#3576E0"));
            } else {
                helper.setTextColor(R.id.strId, Color.parseColor((String)"#333333"));
            }
        }
    }
}

