/*
 * Decompiled with CFR 0.152.
 */
package com.kangxin.common.byh.help;

import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.widget.TextView;
import com.kangxin.common.byh.thread.CountTimeTread;
import com.kangxin.common.util.StringsUtils;
import com.kangxin.doctor.libdata.R;

public class ConsuCountTimeHelper {
    private CountTimeTread mEndConsuThread = new CountTimeTread();
    private TextView mTimeView;
    private String mEndTime;
    private Handler mHandler = new Handler(Looper.getMainLooper()){

        public void handleMessage(Message msg) {
            super.handleMessage(msg);
            switch (msg.what) {
                case 4420: {
                    TimeEntity timeEntity = (TimeEntity)msg.obj;
                    ConsuCountTimeHelper.this.mTimeView.setText((CharSequence)(StringsUtils.getString((int)R.string.commbyh_huizhendaojishi_) + timeEntity.getHourTime() + ":" + timeEntity.getMinuteTime() + ":" + timeEntity.getSecondTime()));
                    break;
                }
                case 4421: {
                    if (ConsuCountTimeHelper.this.onEndConsuTimeCallback == null) {
                        return;
                    }
                    ConsuCountTimeHelper.this.mTimeView.setText((CharSequence)StringsUtils.getString((int)R.string.commbyh_yiwancheng));
                    ConsuCountTimeHelper.this.onEndConsuTimeCallback.onEndConsuTime();
                }
            }
        }
    };
    private static final int RUNING_TIME = 4420;
    private static final int ENDCONSU_TIME = 4421;
    private OnEndConsuTimeCallback onEndConsuTimeCallback;

    public void finishCountTime() {
        this.mEndConsuThread.setExitThread(true);
    }

    public void init(TextView textView, String endTime) {
        this.mTimeView = textView;
        this.mEndTime = endTime;
    }

    public void start(OnEndConsuTimeCallback onEndConsuTimeCallback) {
        this.onEndConsuTimeCallback = onEndConsuTimeCallback;
        this.mEndConsuThread.init(this.mEndTime, new CountTimeTread.OnCountTimeCallback(){

            @Override
            public void showCountTime(int endHour, int endMinute, int endSecond) {
                if (endHour <= 0 && endMinute <= 0 && endSecond <= 0) {
                    ConsuCountTimeHelper.this.mHandler.obtainMessage(4421).sendToTarget();
                    ConsuCountTimeHelper.this.mEndConsuThread.setExitThread(true);
                } else {
                    ConsuCountTimeHelper.this.mHandler.obtainMessage(4420, (Object)new TimeEntity(endHour, endMinute, endSecond)).sendToTarget();
                }
            }
        });
        this.mEndConsuThread.start();
    }

    public static interface OnEndConsuTimeCallback {
        public void onEndConsuTime();
    }

    private class TimeEntity {
        private int hourTime;
        private int minuteTime;
        private int secondTime;

        public TimeEntity(int hourTime, int minuteTime, int secondTime) {
            this.hourTime = hourTime;
            this.minuteTime = minuteTime;
            this.secondTime = secondTime;
        }

        public int getHourTime() {
            return this.hourTime;
        }

        public int getMinuteTime() {
            return this.minuteTime;
        }

        public int getSecondTime() {
            return this.secondTime;
        }
    }
}

