/*
 * Decompiled with CFR 0.152.
 */
package com.kangxin.common.byh.inter;

import android.content.Context;
import android.text.TextUtils;
import android.util.Log;
import com.blankj.utilcode.util.AppUtils;
import com.kangxin.common.byh.ByConfiguration;
import com.kangxin.common.byh.util.VertifyDataUtil;
import com.kangxin.util.common.AppCommUtil;
import java.io.IOException;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;

public class HeaderTokenCeptor
implements Interceptor {
    private static final String TAG = "HeaderTokenCeptor";
    private static final String RESULT_TAG = "token_log";
    private Context mContext;

    public HeaderTokenCeptor(Context mContext) {
        this.mContext = mContext;
    }

    public Response intercept(Interceptor.Chain chain) throws IOException {
        Request request = chain.request();
        Request.Builder builder = request.newBuilder();
        String token = VertifyDataUtil.getInstance(this.mContext).getToken();
        String openCode = VertifyDataUtil.getInstance(this.mContext).getOpenCode();
        Log.i((String)TAG, (String)("token===>" + token));
        if (!TextUtils.isEmpty((CharSequence)openCode)) {
            builder.addHeader("appCode", openCode);
        }
        if (!TextUtils.isEmpty((CharSequence)token)) {
            builder.addHeader("token", token);
            builder.addHeader("accessToken", token);
        }
        builder.addHeader("app_channel", "android");
        builder.addHeader("app_version", AppUtils.getAppVersionName());
        builder.addHeader("accept-language", AppCommUtil.getCurrSysLanguage((Context)this.mContext));
        builder.addHeader("organId", String.valueOf(VertifyDataUtil.getInstance().getHospitalId()));
        String clientType = "";
        if (ByConfiguration.getPlatformCode().equals(ByConfiguration.getByNode())) {
            clientType = "app_byh";
        }
        if (ByConfiguration.getPlatformCode().equals(ByConfiguration.getHtNode())) {
            clientType = "app_hyt";
        }
        if (ByConfiguration.getPlatformCode().equals("NCEFY")) {
            clientType = "app_ndr";
        }
        if (ByConfiguration.getPlatformCode().equals(ByConfiguration.getZdyNode())) {
            clientType = "app_zdy";
        }
        if (ByConfiguration.getPlatformCode().equals("LYCITYYS")) {
            clientType = "app_lyt";
        }
        if (ByConfiguration.getPlatformCode().equals("YCRMYY")) {
            clientType = "app_yc";
        }
        builder.addHeader("doctor-client-type", clientType);
        Log.i((String)TAG, (String)("intercept: sys language is :" + AppCommUtil.getCurrSysLanguage((Context)this.mContext)));
        if (!TextUtils.isEmpty((CharSequence)VertifyDataUtil.getInstance().getUserId())) {
            builder.addHeader("userId", VertifyDataUtil.getInstance().getUserId());
        }
        if (!TextUtils.isEmpty((CharSequence)VertifyDataUtil.getInstance().getDoctorId())) {
            builder.addHeader("doctorId", VertifyDataUtil.getInstance().getDoctorId());
        }
        Response response = chain.proceed(builder.build());
        String url = request.url().toString();
        Request buildReq = builder.build();
        return response;
    }
}

