/*
 * Decompiled with CFR 0.152.
 */
package com.kangxin.common.byh.inter;

import android.text.TextUtils;
import com.alibaba.android.arouter.launcher.ARouter;
import com.blankj.utilcode.util.ToastUtils;
import com.kangxin.common.byh.service.IClearDataProvider;
import com.kangxin.common.util.StringsUtils;
import com.kangxin.doctor.libdata.R;
import com.tencent.bugly.crashreport.CrashReport;
import java.io.IOException;
import java.nio.charset.Charset;
import okhttp3.Interceptor;
import okhttp3.MediaType;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okio.Buffer;
import okio.BufferedSink;
import okio.BufferedSource;
import org.json.JSONException;
import org.json.JSONObject;

public class HttpCodeCeptor
implements Interceptor {
    private static final String TAG = "HttpCodeCeptor";
    private static final Charset UTF8 = Charset.forName("UTF-8");
    private String mResData;
    private static final int CODE_OK = 1;

    public Response intercept(Interceptor.Chain chain) throws IOException {
        Charset resCharset;
        Buffer resBuff;
        String resData;
        Buffer sourceBuff;
        BufferedSource bufferedSource;
        ResponseBody responseBody;
        Request request = chain.request();
        Request.Builder builder = request.newBuilder();
        Response response = chain.proceed(builder.build());
        if (response != null && (responseBody = response.body()) != null && (bufferedSource = responseBody.source()) != null && (sourceBuff = bufferedSource.buffer()) != null && !TextUtils.isEmpty((CharSequence)(resData = (resBuff = sourceBuff.clone()).readString(resCharset = UTF8)))) {
            try {
                JSONObject jsonObject = new JSONObject(resData);
                if (jsonObject.has("code")) {
                    int code = jsonObject.optInt("code");
                    if (code != 1) {
                        this.mResData = resData;
                    }
                    this.operalErrCode(code, request);
                }
                if (jsonObject.has("status")) {
                    int status = jsonObject.optInt("status");
                    this.mResData = resData;
                    this.operalErrCode(status, request);
                }
            }
            catch (JSONException e) {
                CrashReport.postCatchedException((Throwable)e);
                e.printStackTrace();
            }
        }
        return response;
    }

    private void operalErrCode(int code, Request request) throws IOException {
        if (code == 200 || code == 1) {
            return;
        }
        switch (code) {
            case 1110001: {
                ToastUtils.showLong((CharSequence)StringsUtils.getString((int)R.string.commbyh_zhanghaoyidengchuhuozaiqitashebeidenglu));
                IClearDataProvider clearDataProvider = (IClearDataProvider)ARouter.getInstance().build("/AppRouter/clear/data/ClearDataIpmProvider").navigation();
                clearDataProvider.clearLocalData(() -> ARouter.getInstance().build("/VerloginRouter/verification/LoginActivity").navigation());
                break;
            }
            default: {
                StringBuilder infoBuilder = new StringBuilder();
                infoBuilder.append("operalErrCode: " + request.toString() + ", code=" + code + "\n");
                RequestBody body = request.body();
                if (body != null) {
                    Buffer buffer = new Buffer();
                    body.writeTo((BufferedSink)buffer);
                    Charset charset = UTF8;
                    MediaType contentType = body.contentType();
                    if (contentType != null) {
                        charset = contentType.charset(UTF8);
                    }
                    if (charset != null) {
                        infoBuilder.append(", request body:" + buffer.readString(charset));
                    }
                }
                if (this.mResData != null) {
                    infoBuilder.append(", res data:" + this.mResData);
                }
                String infoStr = infoBuilder.toString();
                CrashReport.postCatchedException((Throwable)new Throwable(infoStr));
            }
        }
        this.mResData = null;
    }
}

