/*
 * Decompiled with CFR 0.152.
 */
package com.kangxin.common.byh.module.bh;

import android.content.Context;
import android.text.TextUtils;
import android.util.Log;
import com.blankj.utilcode.util.Utils;
import com.google.gson.JsonObject;
import com.kangxin.common.base.ResponseBody;
import com.kangxin.common.byh.api.v2.BHPatientApi;
import com.kangxin.common.byh.entity.v2.PatientEntityV2;
import com.kangxin.common.byh.module.impl.PatientModule;
import com.kangxin.common.byh.util.VertifyDataUtil;
import com.kangxin.common.util.SchedulesSwitch;
import com.kangxin.common.util.StringsUtils;
import com.kangxin.doctor.libdata.R;
import io.reactivex.Observable;

public class BHPatientModule
extends PatientModule {
    private static final String TAG = "BHPatientModule";

    @Override
    public Observable<ResponseBody<String>> savePatientInfoV2(PatientEntityV2 patientEntity) {
        String openCode = VertifyDataUtil.getInstance((Context)Utils.getApp()).getOpenCode();
        String organIdStr = VertifyDataUtil.getInstance((Context)Utils.getApp()).getRealOrganId();
        Log.i((String)TAG, (String)("savePatientInfoV2: organIdStr:" + organIdStr));
        if (!TextUtils.isEmpty((CharSequence)organIdStr)) {
            Long organId = Long.parseLong(organIdStr);
            patientEntity.setOrganId(organId);
        }
        return ((BHPatientApi)this.createNativeCloudApi(BHPatientApi.class)).savePatient(openCode, patientEntity).map(jsonObjectResponseBody -> {
            ResponseBody responseBody = new ResponseBody();
            if (jsonObjectResponseBody.getData() != null) {
                responseBody.setData((Object)((JsonObject)jsonObjectResponseBody.getData()).get("patientId").getAsString());
            }
            responseBody.setCode(jsonObjectResponseBody.getCode() + "");
            responseBody.setErrCode(jsonObjectResponseBody.getErrCode());
            responseBody.setMsg(jsonObjectResponseBody.getMsg());
            return responseBody;
        }).compose(SchedulesSwitch.applySchedulers());
    }

    public Observable<ResponseBody<String>> savePatientInfoV3(PatientEntityV2 patientEntity) {
        String organIdStr = VertifyDataUtil.getInstance((Context)Utils.getApp()).getRealOrganId();
        Log.i((String)TAG, (String)("savePatientInfoV3: organIdStr:" + organIdStr));
        if (!TextUtils.isEmpty((CharSequence)organIdStr)) {
            Long organId = Long.parseLong(organIdStr);
            patientEntity.setOrganId(organId);
        }
        return ((BHPatientApi)this.createNativeCloudApi(BHPatientApi.class)).savePatientV2(patientEntity, VertifyDataUtil.getInstance().getOpenCode()).map(jsonObjectResponseBody -> {
            ResponseBody responseBody = new ResponseBody();
            responseBody.setCode(jsonObjectResponseBody.getCode() + "");
            responseBody.setErrCode(jsonObjectResponseBody.getErrCode());
            responseBody.setMsg(jsonObjectResponseBody.getMsg());
            String patientId = ((JsonObject)jsonObjectResponseBody.getData()).get("patientId").getAsString();
            String age = ((JsonObject)jsonObjectResponseBody.getData()).get("age").getAsString().replace(StringsUtils.getString((int)R.string.commbyh_sui), "").replace("\"", "");
            responseBody.setData((Object)(patientId + ";" + age));
            return responseBody;
        }).compose(SchedulesSwitch.applySchedulers());
    }
}

