/*
 * Decompiled with CFR 0.152.
 */
package com.kangxin.common.byh.module.bh;

import android.app.Activity;
import android.content.Context;
import com.google.gson.JsonObject;
import com.kangxin.common.byh.api.v2.GlobalApi;
import com.kangxin.common.byh.entity.RegionCtitiesEntity;
import com.kangxin.common.byh.entity.v2.CityEntityV2;
import com.kangxin.common.byh.entity.v2.ProvinceEntityV2;
import com.kangxin.common.byh.util.RegionCitiesUtil;
import com.kangxin.common.util.AppManager;
import com.kangxin.common.util.SchedulesSwitch;
import com.kangxin.common.util.StringsUtils;
import com.kangxin.doctor.libdata.R;
import io.reactivex.Observable;
import java.util.List;

public class GionCitiesModule
extends com.kangxin.common.byh.module.impl.GionCitiesModule {
    @Override
    public Observable<RegionCtitiesEntity> getRegioCities(String fileName) {
        Activity currActivity = AppManager.getAppManager().currentActivity();
        Observable regionCtitiesEntityObservable = null;
        if (currActivity != null) {
            Context context = currActivity.getApplicationContext();
            RegionCitiesUtil regionCitiesUtil = new RegionCitiesUtil(context);
            regionCtitiesEntityObservable = regionCitiesUtil.getRegioCities(fileName).compose(SchedulesSwitch.applySchedulers());
        }
        return regionCtitiesEntityObservable;
    }

    @Override
    public Observable<List<ProvinceEntityV2>> getProvinceV2(String fileName) {
        return ((GlobalApi)this.createApi2(GlobalApi.class)).reqHotprovence().map(listResponseBody -> (List)listResponseBody.getData()).map(results -> {
            ProvinceEntityV2 provinceEntityV2 = new ProvinceEntityV2();
            provinceEntityV2.setProvinceId(900);
            provinceEntityV2.setProvinceCode("900");
            provinceEntityV2.setProvinceName(StringsUtils.getString((int)R.string.commbyh_remenchengshi));
            results.add(0, provinceEntityV2);
            return results;
        }).compose(SchedulesSwitch.applySchedulers());
    }

    @Override
    public Observable<List<CityEntityV2>> getCityV2(String provenceCode) {
        JsonObject object = new JsonObject();
        object.addProperty("provinceCode", provenceCode);
        return ((GlobalApi)this.createApi2(GlobalApi.class)).reqCitys(object).map(listResponseBody -> (List)listResponseBody.getData()).compose(SchedulesSwitch.applySchedulers());
    }
}

