/*
 * Decompiled with CFR 0.152.
 */
package com.kangxin.common.byh.module.impl;

import android.content.Context;
import com.google.gson.JsonObject;
import com.kangxin.common.base.ResponseBody;
import com.kangxin.common.base.mvp.BaseModel;
import com.kangxin.common.byh.api.HospitalApi;
import com.kangxin.common.byh.api.v2.BHHospitalApi;
import com.kangxin.common.byh.entity.DepartmentEntity;
import com.kangxin.common.byh.entity.HospitalEntity;
import com.kangxin.common.byh.entity.MenuDepartmentList;
import com.kangxin.common.byh.entity.PageEntity;
import com.kangxin.common.byh.entity.UnionHospitalEntity;
import com.kangxin.common.byh.entity.v2.HospitalDepEntityV2;
import com.kangxin.common.byh.entity.v2.HospitalDepsmallEntityV2;
import com.kangxin.common.byh.entity.v2.HospitalEntityV2;
import com.kangxin.common.byh.entity.v2.OneDepEntityV2;
import com.kangxin.common.byh.module.IHospitalModule;
import com.kangxin.common.util.SchedulesSwitch;
import io.reactivex.Observable;
import java.util.List;

public class HospitalModule
extends BaseModel
implements IHospitalModule {
    @Override
    public Observable<ResponseBody<List<UnionHospitalEntity>>> getUnionHospitalList(String key, long hospitalId, int index, int pageSize) {
        return ((HospitalApi)this.createApi2(HospitalApi.class)).getUnionHospitalList(key, hospitalId, index, pageSize).compose(SchedulesSwitch.applySchedulers());
    }

    @Override
    public Observable<ResponseBody<List<UnionHospitalEntity>>> getUnionHospitalListV2(String key, long hospitalId, int index, int pageSize) {
        return ((BHHospitalApi)this.createApi2(BHHospitalApi.class)).getUnionHospitalList(key, hospitalId, index, pageSize).compose(SchedulesSwitch.applySchedulers());
    }

    @Override
    public Observable<ResponseBody<PageEntity<HospitalEntity>>> getHospitalListByAreaCode(String searchKey, String areaCode, int index, int pageSize) {
        return ((HospitalApi)this.createApi2(HospitalApi.class)).getHospitalListByAreaCode(searchKey, areaCode, index, pageSize).compose(SchedulesSwitch.applySchedulers());
    }

    @Override
    public Observable<ResponseBody<PageEntity<HospitalEntityV2>>> getHospitalListByAreaCodeV2(String searchKey, String areaCode, int index, int pageSize) {
        JsonObject object = new JsonObject();
        object.addProperty("area", searchKey);
        object.addProperty("distCode", areaCode);
        object.addProperty("page", (Number)index);
        object.addProperty("size", (Number)pageSize);
        return ((BHHospitalApi)this.createApi2(BHHospitalApi.class)).getHospitalListByAreaCode(object).compose(SchedulesSwitch.applySchedulers());
    }

    @Override
    public Observable<ResponseBody<List<DepartmentEntity>>> getHospitalDepartmentList(String hospitalId) {
        return ((HospitalApi)this.createApi2(HospitalApi.class)).getHospitalDepartmentList(hospitalId).compose(SchedulesSwitch.applySchedulers());
    }

    @Override
    public Observable<ResponseBody<List<MenuDepartmentList>>> getHospitalAllDepartmentList(Long hospitalId, Long doctorId) {
        return ((HospitalApi)this.createApi2(HospitalApi.class)).getHospitalAllDepartmentList(hospitalId, doctorId).compose(SchedulesSwitch.applySchedulers());
    }

    @Override
    public Observable<ResponseBody<List<HospitalDepEntityV2>>> getHospitalAllDepartmentListV2(Long hospitalId, String openCode) {
        return null;
    }

    @Override
    public Observable<ResponseBody<List<HospitalDepsmallEntityV2>>> getHospitalSmallDepartmentListV2(Long hospitalId, String appCode) {
        return null;
    }

    @Override
    public Observable<ResponseBody<List<MenuDepartmentList>>> getStandardDepartment() {
        return ((HospitalApi)this.createApi2(HospitalApi.class)).getStandardDepartmentList().compose(SchedulesSwitch.applySchedulers());
    }

    @Override
    public Observable<ResponseBody<List<OneDepEntityV2>>> getStandardDepartmentV2() {
        return null;
    }

    @Override
    public Observable<ResponseBody<List<OneDepEntityV2>>> getStandardDepartmentV2(boolean boo) {
        return null;
    }

    public void init(Context context) {
    }
}

