/*
 * Decompiled with CFR 0.152.
 */
package com.kangxin.common.byh.module.impl;

import android.util.Log;
import com.kangxin.common.base.ResponseBody;
import com.kangxin.common.base.mvp.BaseModel;
import com.kangxin.common.byh.api.FileApi;
import com.kangxin.common.byh.entity.response.UpImgEntity;
import com.kangxin.common.byh.module.IFileModule;
import com.kangxin.common.util.SchedulesSwitch;
import io.reactivex.Observable;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.RequestBody;

public class UpFileModule
extends BaseModel
implements IFileModule {
    private static final String TAG = "UpFileModule";

    @Override
    public Observable<ResponseBody<UpImgEntity>> uploadFile(File file) {
        Log.i((String)TAG, (String)("uploadFile==>>file:" + file));
        RequestBody requestFile = RequestBody.create((MediaType)MediaType.parse((String)"multipart/form-data"), (File)file);
        MultipartBody.Part part = MultipartBody.Part.createFormData((String)"file", (String)file.getName(), (RequestBody)requestFile);
        Log.i((String)TAG, (String)("uploadFile==>>part:" + part));
        return ((FileApi)this.createFitApi(FileApi.class)).uploadFile(part).compose(SchedulesSwitch.applySchedulers());
    }

    @Override
    public Observable<ResponseBody<UpImgEntity>> uploadFile(String filePath) {
        return this.uploadFile(new File(filePath));
    }

    @Override
    public Observable<ResponseBody<List<UpImgEntity>>> uploadFiles(List<String> files) {
        ArrayList<MultipartBody.Part> list = new ArrayList<MultipartBody.Part>();
        for (String filePath : files) {
            if (filePath.equals("")) continue;
            RequestBody requestFile = RequestBody.create((MediaType)MediaType.parse((String)"multipart/form-data"), (File)new File(filePath));
            MultipartBody.Part part = MultipartBody.Part.createFormData((String)"files", (String)filePath, (RequestBody)requestFile);
            list.add(part);
        }
        return ((FileApi)this.createApi2(FileApi.class)).uploadFiles(list).compose(SchedulesSwitch.applySchedulers());
    }
}

