/*
 * Decompiled with CFR 0.152.
 */
package com.kangxin.common.byh.present;

import android.content.Context;
import com.blankj.utilcode.util.ToastUtils;
import com.kangxin.common.base.ResponseBody;
import com.kangxin.common.byh.entity.VertifyIDCardEntity;
import com.kangxin.common.byh.entity.req.ReqWebBody;
import com.kangxin.common.byh.entity.response.LoginSuccess;
import com.kangxin.common.byh.module.IUserModule;
import com.kangxin.common.byh.module.impl.UserModule;
import com.kangxin.common.byh.present.IVerifyPresenter;
import com.kangxin.common.byh.util.VertifyDataUtil;
import com.kangxin.common.byh.view.IModifyProfileView;
import com.kangxin.common.byh.view.IModifySpecialityView;
import com.kangxin.common.byh.view.IPersonalInfoVerifyView;
import com.kangxin.common.byh.view.IVerNameByIdcardView;
import com.kangxin.common.widget.RxProgressObserver;
import io.reactivex.Observer;

public class VerifyPresenter
implements IVerifyPresenter {
    private IPersonalInfoVerifyView mVerifyView;
    private IUserModule mUserModule;
    private IModifyProfileView modifyProfileView;
    private IModifySpecialityView mModifySpecialityView;
    private IVerNameByIdcardView mVerNameIdView;

    public VerifyPresenter(IVerNameByIdcardView mVerNameIdView) {
        this.mVerNameIdView = mVerNameIdView;
        this.mUserModule = new UserModule();
    }

    public VerifyPresenter(IModifySpecialityView mModifySpecialityView) {
        this.mModifySpecialityView = mModifySpecialityView;
        this.mUserModule = new UserModule();
    }

    public VerifyPresenter(IPersonalInfoVerifyView verifyView) {
        this.mVerifyView = verifyView;
        this.mUserModule = new UserModule();
    }

    public VerifyPresenter(IModifyProfileView modifyProfileView) {
        this.modifyProfileView = modifyProfileView;
        this.mUserModule = new UserModule();
    }

    @Override
    public void modifyUserName(Context context, String name) {
        ReqWebBody reqWebBody = new ReqWebBody();
        String accountNo = VertifyDataUtil.getInstance(context).getAccountNo();
        reqWebBody.setAccountNo(accountNo);
        reqWebBody.setDisplayName(name);
        this.mUserModule.modifyUserName(reqWebBody).subscribe((Observer)new RxProgressObserver<ResponseBody<LoginSuccess>>(){

            public void onReqNext(ResponseBody<LoginSuccess> loginSuccessResponseBody) {
                VerifyPresenter.this.mVerifyView.showVerifyResult(loginSuccessResponseBody);
            }
        });
    }

    @Override
    public void modifyProfile(Context context, String profile) {
        ReqWebBody reqWebBody = new ReqWebBody();
        String accountNo = VertifyDataUtil.getInstance(context).getAccountNo();
        reqWebBody.setAccountNo(accountNo);
        reqWebBody.setProfile(profile);
        this.mUserModule.modifyProfile(reqWebBody).subscribe((Observer)new RxProgressObserver<ResponseBody<LoginSuccess>>(){

            public void onReqNext(ResponseBody<LoginSuccess> loginSuccessResponseBody) {
                VerifyPresenter.this.modifyProfileView.modifyProfileOk();
            }
        });
    }

    @Override
    public void modifySpeciality(Context context, String speciality) {
        ReqWebBody reqWebBody = new ReqWebBody();
        String accountNo = VertifyDataUtil.getInstance(context).getAccountNo();
        reqWebBody.setAccountNo(accountNo);
        reqWebBody.setSpeciality(speciality);
        this.mUserModule.modifySpeciality(reqWebBody).subscribe((Observer)new RxProgressObserver<ResponseBody<LoginSuccess>>(){

            public void onReqNext(ResponseBody<LoginSuccess> loginSuccessResponseBody) {
                VerifyPresenter.this.mModifySpecialityView.modifySpecialityOk();
            }
        });
    }

    @Override
    public void verNameByIdcard(Context context, String name, String idcardNum) {
        this.mUserModule.vertifyUserIdCard(idcardNum, name).subscribe((Observer)new RxProgressObserver<ResponseBody<VertifyIDCardEntity>>(){

            public void onReqNext(ResponseBody<VertifyIDCardEntity> vertifyIDCardEntityResponseBody) {
                VertifyIDCardEntity vertifyIDCardEntity = (VertifyIDCardEntity)vertifyIDCardEntityResponseBody.getData();
                if (vertifyIDCardEntity == null) {
                    return;
                }
                if (vertifyIDCardEntity.getCode() != 0) {
                    ToastUtils.showLong((CharSequence)vertifyIDCardEntity.getMsg());
                    return;
                }
                VerifyPresenter.this.mVerNameIdView.vertifySuccess((VertifyIDCardEntity)vertifyIDCardEntityResponseBody.getData());
            }
        });
    }
}

