/*
 * Decompiled with CFR 0.152.
 */
package com.kangxin.common.byh.present.impl;

import android.content.Context;
import com.kangxin.common.base.ResponseBody;
import com.kangxin.common.base.mvp.BasePresenter;
import com.kangxin.common.byh.entity.ExpertCardEntity;
import com.kangxin.common.byh.entity.ExpertItemEntity;
import com.kangxin.common.byh.entity.ExpertServiceEntity;
import com.kangxin.common.byh.module.IUserModule;
import com.kangxin.common.byh.module.impl.UserModule;
import com.kangxin.common.byh.present.IExpertCardInfoPresenter;
import com.kangxin.common.byh.util.VertifyDataUtil;
import com.kangxin.common.byh.view.IExpertCardInfoView;
import com.kangxin.common.rx.ProgressDialogObserver;
import io.reactivex.Observer;
import java.util.List;

public class ExpertCardInfoPresenter
extends BasePresenter
implements IExpertCardInfoPresenter {
    private IExpertCardInfoView mExpertCardInfoView;
    private IUserModule mUserModule;

    public ExpertCardInfoPresenter(IExpertCardInfoView mExpertCardInfoView) {
        this.mExpertCardInfoView = mExpertCardInfoView;
        this.mUserModule = new UserModule();
    }

    @Override
    public void getExpertCardInfo(long doctorId, int applicationChannel) {
        long finalDoctorId = doctorId;
        String loginUserId = VertifyDataUtil.getInstance(this.mContext).getLoginUserId() + "";
        this.mUserModule.getExpertCard(loginUserId, doctorId).filter(result -> {
            if (result.getCode() == 200) {
                return true;
            }
            this.mExpertCardInfoView.error();
            return false;
        }).map(ResponseBody::getResult).doOnNext(expertCardEntity -> {
            List<ExpertServiceEntity> entities = expertCardEntity.getDoctorServiceInfoEntityList();
            if (entities != null && entities.size() > 0) {
                double videoAmount = 0.0;
                double graphAmount = 0.0;
                for (ExpertServiceEntity entity : entities) {
                    if (applicationChannel == 20) {
                        if ("52120".equals(entity.getServiceCode())) {
                            videoAmount = entity.getAmount();
                            continue;
                        }
                        if (!"52110".equals(entity.getServiceCode())) continue;
                        graphAmount = entity.getAmount();
                        continue;
                    }
                    if ("103".equals(entity.getServiceCode())) {
                        videoAmount = entity.getAmount();
                        continue;
                    }
                    if (!"101".equals(entity.getServiceCode())) continue;
                    graphAmount = entity.getAmount();
                }
                this.mExpertCardInfoView.fullService(videoAmount, graphAmount);
            }
        }).doOnNext(expertCardEntity -> this.mExpertCardInfoView.fullExpertEntity((ExpertCardEntity)expertCardEntity)).map(ExpertItemEntity::getDoctorDetailInfoEntity).doOnNext(expertInfoEntity -> this.mExpertCardInfoView.fullEducationExpercise(null)).doOnNext(expertInfoEntity -> this.mExpertCardInfoView.fullWorkExpercise(null)).flatMap(expertInfoEntity -> this.mUserModule.getExpertServiceList(finalDoctorId)).subscribe((Observer)new ProgressDialogObserver<ResponseBody<List<ExpertServiceEntity>>>(){

            public void onNext(ResponseBody<List<ExpertServiceEntity>> responseBody) {
            }

            protected Context attachContext() {
                return ExpertCardInfoPresenter.this.mExpertCardInfoView.injectContext();
            }
        });
    }
}

