/*
 * Decompiled with CFR 0.152.
 */
package com.kangxin.common.byh.present.impl2;

import android.content.Context;
import com.kangxin.common.base.ResponseBody;
import com.kangxin.common.base.mvp.BasePresenter;
import com.kangxin.common.byh.entity.ExpertCardEntity;
import com.kangxin.common.byh.entity.v2.ExpertCardEntityV2;
import com.kangxin.common.byh.module.IUserModule;
import com.kangxin.common.byh.module.impl.UserModule;
import com.kangxin.common.byh.present.IExpertCardInfoPresenter;
import com.kangxin.common.byh.util.VertifyDataUtil;
import com.kangxin.common.byh.view.IExpertCardInfoView;
import com.kangxin.common.rx.ProgressDialogObserver;
import io.reactivex.Observer;
import io.reactivex.functions.Consumer;

public class BHExpertCardInfoPresenter
extends BasePresenter
implements IExpertCardInfoPresenter {
    private IExpertCardInfoView mExpertCardInfoView;
    private IUserModule mUserModule;

    public BHExpertCardInfoPresenter(IExpertCardInfoView mExpertCardInfoView) {
        this.mExpertCardInfoView = mExpertCardInfoView;
        this.mUserModule = new UserModule();
    }

    @Override
    public void getExpertCardInfo(final long doctorId, int applicationChannel) {
        String loginUserId = VertifyDataUtil.getInstance(this.mContext).getDoctorId() + "";
        this.mUserModule.getExpertCardV2(doctorId, loginUserId).filter(result -> {
            if (result.getCode() == 200) {
                return true;
            }
            this.mExpertCardInfoView.error();
            return false;
        }).filter(expertCardEntityResponseBody -> {
            if (expertCardEntityResponseBody.getData() == null) {
                this.mExpertCardInfoView.error();
                return false;
            }
            return true;
        }).map(ResponseBody::getData).doOnNext(expertCardEntity -> {
            ExpertCardEntityV2.ServiceInfoVOBean serviceInfoVO = expertCardEntity.getServiceInfoVO();
            if (serviceInfoVO != null && applicationChannel != 20 && applicationChannel != 10) {
                this.mExpertCardInfoView.fullService(serviceInfoVO.getVideoPrice(), serviceInfoVO.getGraphicPrice());
            }
        }).doOnNext((Consumer)new Consumer<ExpertCardEntityV2>(){

            public void accept(ExpertCardEntityV2 expertCardEntityV2) throws Exception {
                BHExpertCardInfoPresenter.this.mExpertCardInfoView.fullExpertInfo(expertCardEntityV2.getDetailsInfoVO().getName(), expertCardEntityV2.getDetailsInfoVO().getProfession(), expertCardEntityV2.getDetailsInfoVO().getRegHospitalName(), expertCardEntityV2.getDetailsInfoVO().getHospitalDeptName(), expertCardEntityV2.getDetailsInfoVO().getHeadPortrait());
                BHExpertCardInfoPresenter.this.mExpertCardInfoView.fullTeamInfo(expertCardEntityV2.getDoctorTeamDetailVO());
            }
        }).doOnNext(expertCardEntity -> this.mExpertCardInfoView.fullSpeciality(expertCardEntity.getDetailsInfoVO().getSpeciality())).doOnNext(expertCardEntity -> this.mExpertCardInfoView.fullExpertProfile(expertCardEntity.getDetailsInfoVO().getProfile())).doOnNext(expertInfoEntity -> this.mExpertCardInfoView.fullEducationExpercise(expertInfoEntity.getDetailsInfoVO().getSchoolMessageVOS())).doOnNext(expertInfoEntity -> this.mExpertCardInfoView.fullWorkExpercise(expertInfoEntity.getDetailsInfoVO().getHospitalMessageVOs())).subscribe((Observer)new ProgressDialogObserver<ExpertCardEntity>(){

            public void onNext(ExpertCardEntity expertCardEntity) {
                expertCardEntity.getDetailsInfoVO().setDoctorId(doctorId);
                BHExpertCardInfoPresenter.this.mExpertCardInfoView.fullExpertEntity(expertCardEntity);
            }

            protected Context attachContext() {
                return BHExpertCardInfoPresenter.this.mExpertCardInfoView.injectContext();
            }
        });
    }
}

