/*
 * Decompiled with CFR 0.152.
 */
package com.kangxin.common.byh.prompter;

import android.app.Activity;
import android.content.Context;
import android.view.View;
import android.widget.Button;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.appcompat.app.AlertDialog;
import com.kangxin.common.util.StringsUtils;
import com.kangxin.doctor.libdata.R;
import ezy.boost.update.IUpdateAgent;
import ezy.boost.update.IUpdatePrompter;
import ezy.boost.update.UpdateInfo;

public class RocketUpdatePrompter
implements IUpdatePrompter {
    private Activity mContext;

    public RocketUpdatePrompter(Activity context) {
        this.mContext = context;
    }

    public void prompt(final IUpdateAgent agent) {
        if (this.mContext == null || this.mContext.isFinishing()) {
            return;
        }
        UpdateInfo info = agent.getInfo();
        String updateContent = info.updateContent;
        final AlertDialog dialog = new AlertDialog.Builder((Context)this.mContext, R.style.worktab_AlertDialogStyle).create();
        View rootView = View.inflate((Context)this.mContext, (int)R.layout.commbyh_rokect_update_dialog, null);
        dialog.setCanceledOnTouchOutside(false);
        dialog.setView(rootView);
        TextView updateTitleView = (TextView)rootView.findViewById(R.id.update_title);
        TextView updateContentView = (TextView)rootView.findViewById(R.id.update_content);
        TextView forceUpdateDescView = (TextView)rootView.findViewById(R.id.force_update_desc);
        View ignoreViewLayout = rootView.findViewById(R.id.ignore_layout);
        ImageView closeBtnView = (ImageView)rootView.findViewById(R.id.close_btn);
        updateTitleView.setText((CharSequence)(StringsUtils.getString((int)R.string.commbyh_faxianxinbanben) + info.versionName));
        updateContentView.setText((CharSequence)updateContent);
        Button forceUpdateBtn = (Button)rootView.findViewById(R.id.force_update_btn);
        TextView ignoreUpdateBtn = (TextView)rootView.findViewById(R.id.ignore_update_btn);
        String fileSize = info.size + "M";
        forceUpdateBtn.setText((CharSequence)(StringsUtils.getString((int)R.string.commbyh_xiazaigengxin_) + fileSize));
        if (info.isForce) {
            closeBtnView.setVisibility(8);
            ignoreUpdateBtn.setVisibility(8);
            forceUpdateDescView.setVisibility(0);
        } else {
            closeBtnView.setVisibility(0);
            ignoreUpdateBtn.setVisibility(0);
            forceUpdateDescView.setVisibility(8);
        }
        if (info.isClickCheckUpdate) {
            ignoreViewLayout.setVisibility(8);
            closeBtnView.setVisibility(0);
        }
        forceUpdateBtn.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                agent.update();
                dialog.dismiss();
            }
        });
        ignoreUpdateBtn.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                agent.ignore();
                dialog.dismiss();
            }
        });
        closeBtnView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                dialog.dismiss();
            }
        });
        dialog.show();
    }
}

