/*
 * Decompiled with CFR 0.152.
 */
package com.kangxin.common.byh.provider;

import android.content.Context;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import com.blankj.utilcode.util.Utils;
import com.kangxin.common.base.ResponseBody;
import com.kangxin.common.byh.entity.response.UserSignRes;
import com.kangxin.common.byh.module.impl.UserModule;
import com.kangxin.common.byh.util.VertifyDataUtil;
import com.kangxin.common.widget.RxBaseObserver;
import io.reactivex.Observer;

public class UserSignProvider {
    private static final UserSignProvider ourInstance = new UserSignProvider();

    public static UserSignProvider getInstance() {
        return ourInstance;
    }

    private UserSignProvider() {
    }

    public void reqTecentUserSign(final OnUserSignCallBack onUserSignCallBack) {
        new UserModule().queryUserLogin().subscribe((Observer)new RxBaseObserver<ResponseBody<UserSignRes>>(){

            public void onReqNext(ResponseBody<UserSignRes> userSignResResponseBody) {
                UserSignRes userSignRes = (UserSignRes)userSignResResponseBody.getData();
                if (userSignRes != null) {
                    String account = userSignRes.getSdkAccount();
                    String userSign = userSignRes.getSig();
                    if (!TextUtils.isEmpty((CharSequence)account) && !TextUtils.isEmpty((CharSequence)userSign)) {
                        if (onUserSignCallBack != null) {
                            onUserSignCallBack.onUserSign(account, userSign);
                        }
                        VertifyDataUtil.getInstance((Context)Utils.getApp()).setTecentSdkSign(account, userSign);
                    } else if (onUserSignCallBack != null) {
                        onUserSignCallBack.onErr(0);
                    }
                } else if (onUserSignCallBack != null) {
                    onUserSignCallBack.onErr(0);
                }
            }

            public void onError(Throwable e) {
                if (onUserSignCallBack != null) {
                    onUserSignCallBack.onErr(0);
                }
            }

            public void onComplete() {
            }
        });
    }

    public static interface OnUserSignCallBack {
        public void onUserSign(@NonNull String var1, @NonNull String var2);

        public void onErr(int var1);
    }
}

