/*
 * Decompiled with CFR 0.152.
 */
package com.kangxin.common.byh.util;

import android.content.ClipData;
import android.content.ClipboardManager;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import com.blankj.utilcode.util.Utils;

public final class ClipboardUtils {
    private ClipboardUtils() {
        throw new UnsupportedOperationException("u can't instantiate me...");
    }

    public static void copyText(CharSequence text) {
        ClipboardManager cm = (ClipboardManager)Utils.getApp().getSystemService("clipboard");
        cm.setPrimaryClip(ClipData.newPlainText((CharSequence)"text", (CharSequence)text));
    }

    public static CharSequence getText() {
        ClipboardManager cm = (ClipboardManager)Utils.getApp().getSystemService("clipboard");
        ClipData clip = cm.getPrimaryClip();
        if (clip != null && clip.getItemCount() > 0) {
            return clip.getItemAt(0).coerceToText((Context)Utils.getApp());
        }
        return null;
    }

    public static void copyUri(Uri uri) {
        ClipboardManager cm = (ClipboardManager)Utils.getApp().getSystemService("clipboard");
        cm.setPrimaryClip(ClipData.newUri((ContentResolver)Utils.getApp().getContentResolver(), (CharSequence)"uri", (Uri)uri));
    }

    public static Uri getUri() {
        ClipboardManager cm = (ClipboardManager)Utils.getApp().getSystemService("clipboard");
        ClipData clip = cm.getPrimaryClip();
        if (clip != null && clip.getItemCount() > 0) {
            return clip.getItemAt(0).getUri();
        }
        return null;
    }

    public static void copyIntent(Intent intent) {
        ClipboardManager cm = (ClipboardManager)Utils.getApp().getSystemService("clipboard");
        cm.setPrimaryClip(ClipData.newIntent((CharSequence)"intent", (Intent)intent));
    }

    public static Intent getIntent() {
        ClipboardManager cm = (ClipboardManager)Utils.getApp().getSystemService("clipboard");
        ClipData clip = cm.getPrimaryClip();
        if (clip != null && clip.getItemCount() > 0) {
            return clip.getItemAt(0).getIntent();
        }
        return null;
    }
}

