/*
 * Decompiled with CFR 0.152.
 */
package com.kangxin.common.byh.util;

import android.content.Context;
import android.text.TextUtils;
import com.blankj.utilcode.util.ToastUtils;
import com.google.gson.Gson;
import com.kangxin.common.byh.entity.RegionCtitiesEntity;
import io.reactivex.Observable;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;

public class RegionCitiesUtil {
    private Context mContext;

    public RegionCitiesUtil(Context context) {
        this.mContext = context;
    }

    public Observable<RegionCtitiesEntity> getRegioCities(String fileName) {
        return Observable.create(emitter -> {
            String cyJson = this.getCititesByAssets(fileName);
            if (TextUtils.isEmpty((CharSequence)cyJson)) {
                emitter.onError((Throwable)new IllegalAccessError("json is null"));
            }
            Gson gson = new Gson();
            RegionCtitiesEntity regionCtitiesEntity = (RegionCtitiesEntity)gson.fromJson(cyJson, RegionCtitiesEntity.class);
            emitter.onNext((Object)regionCtitiesEntity);
            emitter.onComplete();
        });
    }

    public RegionCtitiesEntity getNormalRegioCities(String fileName) {
        String cyJson = this.getCititesByAssets(fileName);
        if (TextUtils.isEmpty((CharSequence)cyJson)) {
            ToastUtils.showShort((CharSequence)"city data is null");
            return null;
        }
        Gson gson = new Gson();
        RegionCtitiesEntity regionCtitiesEntity = (RegionCtitiesEntity)gson.fromJson(cyJson, RegionCtitiesEntity.class);
        return regionCtitiesEntity;
    }

    private String getCititesByAssets(String fileName) {
        InputStream is = null;
        ByteArrayOutputStream bos = null;
        try {
            is = this.mContext.getAssets().open(fileName);
            bos = new ByteArrayOutputStream();
            byte[] bytes = new byte[4096];
            int len = 0;
            while ((len = is.read(bytes)) != -1) {
                bos.write(bytes, 0, len);
            }
            String json = new String(bos.toByteArray());
            return json;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

