/*
 * Decompiled with CFR 0.152.
 */
package com.kangxin.common.byh.util;

import android.content.Context;
import android.graphics.Bitmap;
import com.byh.module.onlineoutser.im.utils.LocalFileUtils;
import com.kangxin.common.base.ResponseBody;
import com.kangxin.common.byh.api.FileApi;
import com.kangxin.common.byh.entity.response.UpImgEntity;
import com.kangxin.common.http.RetrofitHelpr;
import id.zelory.compressor.Compressor;
import io.reactivex.Observer;
import io.reactivex.android.schedulers.AndroidSchedulers;
import io.reactivex.disposables.Disposable;
import io.reactivex.schedulers.Schedulers;
import java.io.File;
import java.io.IOException;
import java.util.List;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.RequestBody;

public class UploadUtils {
    public static void upload(List<String> paths, final Runnable<String> results) {
        for (String item : paths) {
            UploadUtils.upload(item, new Runnable<String>(){

                @Override
                public void run(String s) {
                    if (results != null) {
                        results.run(s);
                    }
                }
            });
        }
    }

    public static void upload(Context context, List<String> paths, final Runnable<String> results) {
        for (String item : paths) {
            UploadUtils.upload(context, item, new Runnable<String>(){

                @Override
                public void run(String s) {
                    if (results != null) {
                        results.run(s);
                    }
                }
            });
        }
    }

    private static void upload(final String item, final Runnable<String> runnable) {
        File file = new File(item);
        if (!file.exists()) {
            try {
                throw new Exception("not file");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        RequestBody requestFile = RequestBody.create((MediaType)MediaType.parse((String)"multipart/form-data"), (File)file);
        MultipartBody.Part part = MultipartBody.Part.createFormData((String)"file", (String)(System.currentTimeMillis() + ""), (RequestBody)requestFile);
        ((FileApi)RetrofitHelpr.getInstance().createApi(FileApi.class)).uploadFile(part).subscribeOn(Schedulers.io()).observeOn(AndroidSchedulers.mainThread()).subscribe((Observer)new Observer<ResponseBody<UpImgEntity>>(){

            public void onSubscribe(Disposable d) {
            }

            public void onNext(ResponseBody<UpImgEntity> upImgEntityResponseBody) {
                runnable.run(((UpImgEntity)upImgEntityResponseBody.getResult()).getUrl());
            }

            public void onError(Throwable e) {
                UploadUtils.upload(item, (Runnable<String>)runnable);
            }

            public void onComplete() {
            }
        });
    }

    private static void upload(Context context, final String item, final Runnable<String> runnable) {
        File file = new File(item);
        if (!file.exists()) {
            try {
                throw new Exception("not file");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        try {
            File result = new Compressor(context).setCompressFormat(Bitmap.CompressFormat.JPEG).setDestinationDirectoryPath(LocalFileUtils.getImageFileDir((Context)context)).compressToFile(new File(item), System.currentTimeMillis() + ".png");
            RequestBody requestFile = RequestBody.create((MediaType)MediaType.parse((String)"multipart/form-data"), (File)result);
            MultipartBody.Part part = MultipartBody.Part.createFormData((String)"file", (String)(System.currentTimeMillis() + ""), (RequestBody)requestFile);
            ((FileApi)RetrofitHelpr.getInstance().createApi(FileApi.class)).uploadFile(part).subscribeOn(Schedulers.io()).observeOn(AndroidSchedulers.mainThread()).subscribe((Observer)new Observer<ResponseBody<UpImgEntity>>(){

                public void onSubscribe(Disposable d) {
                }

                public void onNext(ResponseBody<UpImgEntity> upImgEntityResponseBody) {
                    runnable.run(((UpImgEntity)upImgEntityResponseBody.getResult()).getUrl());
                }

                public void onError(Throwable e) {
                    UploadUtils.upload(item, (Runnable<String>)runnable);
                }

                public void onComplete() {
                }
            });
        }
        catch (IOException e) {
            UploadUtils.upload(item, runnable);
        }
    }

    public static interface Runnable<T> {
        public void run(T var1);
    }
}

