/*
 * Decompiled with CFR 0.152.
 */
package com.kangxin.common.byh.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.util.AttributeSet;
import android.view.View;
import com.kangxin.doctor.libdata.R;

public class DashView
extends View {
    private static final String TAG = "DashView";
    public static final int DEFAULT_DASH_WIDTH = 100;
    public static final int DEFAULT_LINE_WIDTH = 100;
    public static final int DEFAULT_LINE_HEIGHT = 10;
    public static final int DEFAULT_LINE_COLOR = 0x9E9E9E;
    public static final int ORIENTATION_HORIZONTAL = 0;
    public static final int ORIENTATION_VERTICAL = 1;
    public static final int DEFAULT_DASH_ORIENTATION = 0;
    private float dashWidth;
    private float lineHeight;
    private float lineWidth;
    private int lineColor;
    private int dashOrientation;
    private Paint mPaint = new Paint(1);
    private int widthSize;
    private int heightSize;

    public DashView(Context context) {
        this(context, null);
    }

    public DashView(Context context, AttributeSet attrs) {
        super(context, attrs);
        TypedArray typedArray = context.obtainStyledAttributes(attrs, R.styleable.DashView);
        this.dashWidth = typedArray.getDimension(R.styleable.DashView_dashWidth, 100.0f);
        this.lineHeight = typedArray.getDimension(R.styleable.DashView_lineHeight, 10.0f);
        this.lineWidth = typedArray.getDimension(R.styleable.DashView_lineWidth, 100.0f);
        this.lineColor = typedArray.getColor(R.styleable.DashView_lineColor, 0x9E9E9E);
        this.dashOrientation = typedArray.getInteger(R.styleable.DashView_dashOrientation, 0);
        this.mPaint.setColor(this.lineColor);
        this.mPaint.setStrokeWidth(this.lineHeight);
        typedArray.recycle();
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        this.widthSize = View.MeasureSpec.getSize((int)widthMeasureSpec) - this.getPaddingLeft() - this.getPaddingRight();
        this.heightSize = View.MeasureSpec.getSize((int)(heightMeasureSpec - this.getPaddingTop() - this.getPaddingBottom()));
        if (this.dashOrientation == 0) {
            this.setMeasuredDimension(this.widthSize, (int)this.lineHeight);
        } else {
            this.setMeasuredDimension((int)this.lineHeight, this.heightSize);
        }
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        switch (this.dashOrientation) {
            case 1: {
                this.drawVerticalLine(canvas);
                break;
            }
            default: {
                this.drawHorizontalLine(canvas);
            }
        }
    }

    public void drawHorizontalLine(Canvas canvas) {
        canvas.save();
        float[] pts = new float[]{0.0f, 0.0f, this.lineWidth, 0.0f};
        canvas.translate(0.0f, this.lineHeight / 2.0f);
        for (float totalWidth = 0.0f; totalWidth <= (float)this.widthSize; totalWidth += this.lineWidth + this.dashWidth) {
            canvas.drawLines(pts, this.mPaint);
            canvas.translate(this.lineWidth + this.dashWidth, 0.0f);
        }
        canvas.restore();
    }

    public void drawVerticalLine(Canvas canvas) {
        canvas.save();
        float[] pts = new float[]{0.0f, 0.0f, 0.0f, this.lineWidth};
        canvas.translate(this.lineHeight / 2.0f, 0.0f);
        for (float totalWidth = 0.0f; totalWidth <= (float)this.heightSize; totalWidth += this.lineWidth + this.dashWidth) {
            canvas.drawLines(pts, this.mPaint);
            canvas.translate(0.0f, this.lineWidth + this.dashWidth);
        }
        canvas.restore();
    }
}

