/*
 * Decompiled with CFR 0.152.
 */
package com.kangxin.common.byh.widget.DatePicker;

import android.animation.ObjectAnimator;
import android.animation.PropertyValuesHolder;
import android.app.Dialog;
import android.content.Context;
import android.util.DisplayMetrics;
import android.view.View;
import android.view.Window;
import android.view.WindowManager;
import android.widget.TextView;
import com.kangxin.doctor.libdata.R;
import com.kangxin.widget.worktab.DatePickerView;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Locale;

public class CustomDatePicker {
    private int scrollUnits;
    private DialogShowOrDismiss mDialogShowOrDismiss;
    private ResultHandler handler;
    private Context context;
    private boolean canAccess;
    private Dialog datePickerDialog;
    private DatePickerView year_pv;
    private DatePickerView month_pv;
    private DatePickerView day_pv;
    private DatePickerView hour_pv;
    private DatePickerView minute_pv;
    private static final int MAX_MINUTE = 59;
    private static final int MAX_HOUR = 23;
    private static final int MIN_MINUTE = 0;
    private static final int MIN_HOUR = 0;
    private static final int MAX_MONTH = 12;
    private ArrayList<String> year;
    private ArrayList<String> month;
    private ArrayList<String> day;
    private ArrayList<String> hour;
    private ArrayList<String> minute;
    private int startYear;
    private int startMonth;
    private int startDay;
    private int startHour;
    private int startMinute;
    private int endYear;
    private int endMonth;
    private int endDay;
    private int endHour;
    private int endMinute;
    private int lastMonthDays;
    private String title;
    private String currentMon;
    private String currentDay;
    private String currentHour;
    private String currentMin;
    private boolean spanYear;
    private boolean spanMon;
    private boolean spanDay;
    private boolean spanHour;
    private boolean spanMin;
    private Calendar selectedCalender;
    private Calendar startCalendar;
    private Calendar endCalendar;
    private TextView tv_title;
    private TextView tv_cancle;
    private TextView tv_select;
    private TextView day_text;
    private TextView hour_text;
    private TextView minute_text;

    public CustomDatePicker(Context context, String title, ResultHandler resultHandler, String startDate, String endDate, DialogShowOrDismiss dialogShowOrDismiss) {
        this.scrollUnits = SCROLL_TYPE.HOUR.value + SCROLL_TYPE.MINUTE.value;
        this.canAccess = false;
        if (this.isValidDate(startDate, "yyyy-MM-dd HH:mm") && this.isValidDate(endDate, "yyyy-MM-dd HH:mm")) {
            this.canAccess = true;
            this.context = context;
            this.handler = resultHandler;
            this.mDialogShowOrDismiss = dialogShowOrDismiss;
            this.title = title;
            this.selectedCalender = Calendar.getInstance();
            this.startCalendar = Calendar.getInstance();
            this.endCalendar = Calendar.getInstance();
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm", Locale.CHINA);
            try {
                this.startCalendar.setTime(sdf.parse(startDate));
                this.endCalendar.setTime(sdf.parse(endDate));
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
            this.initDialog();
            this.initView();
        }
    }

    private void initDialog() {
        if (this.datePickerDialog == null) {
            this.datePickerDialog = new Dialog(this.context, R.style.TimePickerDialog);
            this.datePickerDialog.setCancelable(false);
            this.datePickerDialog.requestWindowFeature(1);
            this.datePickerDialog.setContentView(R.layout.by_view_custom_date_picker);
            Window window = this.datePickerDialog.getWindow();
            window.setGravity(80);
            window.getDecorView().setPadding(0, 0, 0, 0);
            WindowManager manager = (WindowManager)this.context.getSystemService("window");
            DisplayMetrics dm = new DisplayMetrics();
            manager.getDefaultDisplay().getMetrics(dm);
            WindowManager.LayoutParams lp = window.getAttributes();
            lp.width = -1;
            lp.height = -2;
            window.setAttributes(lp);
            this.datePickerDialog.setOnDismissListener(dialog -> this.mDialogShowOrDismiss.dismiss());
            this.datePickerDialog.setOnShowListener(dialog -> this.mDialogShowOrDismiss.show());
        }
    }

    private void initView() {
        this.year_pv = (DatePickerView)this.datePickerDialog.findViewById(R.id.year_pv);
        this.month_pv = (DatePickerView)this.datePickerDialog.findViewById(R.id.month_pv);
        this.day_pv = (DatePickerView)this.datePickerDialog.findViewById(R.id.day_pv);
        this.hour_pv = (DatePickerView)this.datePickerDialog.findViewById(R.id.hour_pv);
        this.minute_pv = (DatePickerView)this.datePickerDialog.findViewById(R.id.minute_pv);
        this.tv_title = (TextView)this.datePickerDialog.findViewById(R.id.tv_title);
        this.tv_cancle = (TextView)this.datePickerDialog.findViewById(R.id.tv_cancle);
        this.tv_select = (TextView)this.datePickerDialog.findViewById(R.id.tv_select);
        this.day_text = (TextView)this.datePickerDialog.findViewById(R.id.day_text);
        this.hour_text = (TextView)this.datePickerDialog.findViewById(R.id.hour_text);
        this.minute_text = (TextView)this.datePickerDialog.findViewById(R.id.minute_text);
        this.tv_title.setText((CharSequence)this.title);
        this.tv_cancle.setOnClickListener(view -> this.datePickerDialog.dismiss());
        this.tv_select.setOnClickListener(view -> {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm", Locale.CHINA);
            this.handler.handle(sdf.format(this.selectedCalender.getTime()));
            this.datePickerDialog.dismiss();
        });
    }

    private void initParameter() {
        this.startYear = this.startCalendar.get(1);
        this.startMonth = this.startCalendar.get(2) + 1;
        this.startDay = this.startCalendar.get(5);
        this.startHour = this.startCalendar.get(11);
        this.startMinute = this.startCalendar.get(12);
        this.endYear = this.endCalendar.get(1);
        this.endMonth = this.endCalendar.get(2) + 1;
        this.endDay = this.endCalendar.get(5);
        this.endHour = this.endCalendar.get(11);
        this.endMinute = this.endCalendar.get(12);
        this.spanYear = this.startYear != this.endYear;
        this.spanMon = !this.spanYear && this.startMonth != this.endMonth;
        this.spanDay = !this.spanMon && this.startDay != this.endDay;
        this.spanHour = !this.spanDay && this.startHour != this.endHour;
        this.spanMin = !this.spanHour && this.startMinute != this.endMinute;
        this.selectedCalender.setTime(this.startCalendar.getTime());
    }

    private void initTimer() {
        this.initArrayList();
        if (this.spanYear) {
            int i;
            for (i = this.startYear; i <= this.endYear; ++i) {
                this.year.add(String.valueOf(i));
            }
            for (i = this.startMonth; i <= 12; ++i) {
                this.month.add(this.formatTimeUnit(i));
            }
            for (i = this.startDay; i <= this.startCalendar.getActualMaximum(5); ++i) {
                this.day.add(this.formatTimeUnit(i));
            }
            if ((this.scrollUnits & SCROLL_TYPE.HOUR.value) != SCROLL_TYPE.HOUR.value) {
                this.hour.add(this.formatTimeUnit(this.startHour));
            } else {
                for (i = this.startHour; i <= 23; ++i) {
                    this.hour.add(this.formatTimeUnit(i));
                }
            }
            if ((this.scrollUnits & SCROLL_TYPE.MINUTE.value) != SCROLL_TYPE.MINUTE.value) {
                this.minute.add(this.formatTimeUnit(this.startMinute));
            } else {
                for (i = this.startMinute; i <= 59; ++i) {
                    this.minute.add(this.formatTimeUnit(i));
                }
            }
        } else if (this.spanMon) {
            int i;
            this.year.add(String.valueOf(this.startYear));
            for (i = this.startMonth; i <= this.endMonth; ++i) {
                this.month.add(this.formatTimeUnit(i));
            }
            for (i = this.startDay; i <= this.startCalendar.getActualMaximum(5); ++i) {
                this.day.add(this.formatTimeUnit(i));
            }
            if ((this.scrollUnits & SCROLL_TYPE.HOUR.value) != SCROLL_TYPE.HOUR.value) {
                this.hour.add(this.formatTimeUnit(this.startHour));
            } else {
                for (i = this.startHour; i <= 23; ++i) {
                    this.hour.add(this.formatTimeUnit(i));
                }
            }
            if ((this.scrollUnits & SCROLL_TYPE.MINUTE.value) != SCROLL_TYPE.MINUTE.value) {
                this.minute.add(this.formatTimeUnit(this.startMinute));
            } else {
                for (i = this.startMinute; i <= 59; ++i) {
                    this.minute.add(this.formatTimeUnit(i));
                }
            }
        } else if (this.spanDay) {
            int i;
            this.year.add(String.valueOf(this.startYear));
            this.month.add(this.formatTimeUnit(this.startMonth));
            for (i = this.startDay; i <= this.endDay; ++i) {
                this.day.add(this.formatTimeUnit(i));
            }
            if ((this.scrollUnits & SCROLL_TYPE.HOUR.value) != SCROLL_TYPE.HOUR.value) {
                this.hour.add(this.formatTimeUnit(this.startHour));
            } else {
                for (i = this.startHour; i <= 23; ++i) {
                    this.hour.add(this.formatTimeUnit(i));
                }
            }
            if ((this.scrollUnits & SCROLL_TYPE.MINUTE.value) != SCROLL_TYPE.MINUTE.value) {
                this.minute.add(this.formatTimeUnit(this.startMinute));
            } else {
                for (i = this.startMinute; i <= 59; ++i) {
                    this.minute.add(this.formatTimeUnit(i));
                }
            }
        } else if (this.spanHour) {
            int i;
            this.year.add(String.valueOf(this.startYear));
            this.month.add(this.formatTimeUnit(this.startMonth));
            this.day.add(this.formatTimeUnit(this.startDay));
            if ((this.scrollUnits & SCROLL_TYPE.HOUR.value) != SCROLL_TYPE.HOUR.value) {
                this.hour.add(this.formatTimeUnit(this.startHour));
            } else {
                for (i = this.startHour; i <= this.endHour; ++i) {
                    this.hour.add(this.formatTimeUnit(i));
                }
            }
            if ((this.scrollUnits & SCROLL_TYPE.MINUTE.value) != SCROLL_TYPE.MINUTE.value) {
                this.minute.add(this.formatTimeUnit(this.startMinute));
            } else {
                for (i = this.startMinute; i <= 59; ++i) {
                    this.minute.add(this.formatTimeUnit(i));
                }
            }
        } else if (this.spanMin) {
            this.year.add(String.valueOf(this.startYear));
            this.month.add(this.formatTimeUnit(this.startMonth));
            this.day.add(this.formatTimeUnit(this.startDay));
            this.hour.add(this.formatTimeUnit(this.startHour));
            if ((this.scrollUnits & SCROLL_TYPE.MINUTE.value) != SCROLL_TYPE.MINUTE.value) {
                this.minute.add(this.formatTimeUnit(this.startMinute));
            } else {
                for (int i = this.startMinute; i <= this.endMinute; ++i) {
                    this.minute.add(this.formatTimeUnit(i));
                }
            }
        }
        this.loadComponent();
    }

    private String formatTimeUnit(int unit) {
        return unit < 10 ? "0" + String.valueOf(unit) : String.valueOf(unit);
    }

    private void initArrayList() {
        if (this.year == null) {
            this.year = new ArrayList();
        }
        if (this.month == null) {
            this.month = new ArrayList();
        }
        if (this.day == null) {
            this.day = new ArrayList();
        }
        if (this.hour == null) {
            this.hour = new ArrayList();
        }
        if (this.minute == null) {
            this.minute = new ArrayList();
        }
        this.year.clear();
        this.month.clear();
        this.day.clear();
        this.hour.clear();
        this.minute.clear();
    }

    private void loadComponent() {
        this.year_pv.setData(this.year);
        this.month_pv.setData(this.month);
        this.day_pv.setData(this.day);
        this.hour_pv.setData(this.hour);
        this.minute_pv.setData(this.minute);
        this.year_pv.setSelected(0);
        this.month_pv.setSelected(0);
        this.day_pv.setSelected(0);
        this.hour_pv.setSelected(0);
        this.minute_pv.setSelected(0);
        this.executeScroll();
    }

    private void addListener() {
        this.year_pv.setOnSelectListener(new DatePickerView.onSelectListener(){

            public void onSelect(String text) {
                CustomDatePicker.this.selectedCalender.set(1, Integer.parseInt(text));
                CustomDatePicker.this.monthChange();
            }
        });
        this.month_pv.setOnSelectListener(new DatePickerView.onSelectListener(){

            public void onSelect(String text) {
                CustomDatePicker.this.selectedCalender.set(5, 1);
                CustomDatePicker.this.selectedCalender.set(2, Integer.parseInt(text) - 1);
                CustomDatePicker.this.currentMon = text;
                CustomDatePicker.this.dayChange();
            }
        });
        this.day_pv.setOnSelectListener(new DatePickerView.onSelectListener(){

            public void onSelect(String text) {
                CustomDatePicker.this.selectedCalender.set(5, Integer.parseInt(text));
                CustomDatePicker.this.currentDay = text;
                CustomDatePicker.this.hourChange();
            }
        });
        this.hour_pv.setOnSelectListener(text -> {
            this.selectedCalender.set(11, Integer.parseInt(text));
            this.currentHour = text;
            this.minuteChange();
        });
        this.minute_pv.setOnSelectListener(text -> {
            this.selectedCalender.set(12, Integer.parseInt(text));
            this.currentMin = text;
        });
    }

    private void monthChange() {
        this.month.clear();
        int selectedYear = this.selectedCalender.get(1);
        if (selectedYear == this.startYear) {
            for (int i = this.startMonth; i <= 12; ++i) {
                this.month.add(this.formatTimeUnit(i));
            }
        } else if (selectedYear == this.endYear) {
            for (int i = 1; i <= this.endMonth; ++i) {
                this.month.add(this.formatTimeUnit(i));
            }
        } else {
            for (int i = 1; i <= 12; ++i) {
                this.month.add(this.formatTimeUnit(i));
            }
        }
        this.month_pv.setData(this.month);
        if (this.month.size() < 12 && Integer.valueOf(this.currentMon) > this.month.size()) {
            this.month_pv.setSelected(this.month.size() - 1);
            this.selectedCalender.set(5, 1);
            this.selectedCalender.set(2, this.month.size() - 1);
        } else {
            this.month_pv.setSelected(this.currentMon);
            this.selectedCalender.set(5, 1);
            this.selectedCalender.set(2, Integer.valueOf(this.currentMon) - 1);
        }
        this.executeAnimator((View)this.month_pv);
        this.month_pv.postDelayed(() -> this.dayChange(), 100L);
    }

    private void dayChange() {
        this.day.clear();
        int selectedYear = this.selectedCalender.get(1);
        int selectedMonth = this.selectedCalender.get(2) + 1;
        if (selectedYear == this.startYear && selectedMonth == this.startMonth) {
            for (int i = this.startDay; i <= this.selectedCalender.getActualMaximum(5); ++i) {
                this.day.add(this.formatTimeUnit(i));
            }
        } else if (selectedYear == this.endYear && selectedMonth == this.endMonth) {
            for (int i = 1; i <= this.endDay; ++i) {
                this.day.add(this.formatTimeUnit(i));
            }
        } else {
            for (int i = 1; i <= this.selectedCalender.getActualMaximum(5); ++i) {
                this.day.add(this.formatTimeUnit(i));
            }
        }
        this.day_pv.setData(this.day);
        if (this.day.size() < this.lastMonthDays && Integer.valueOf(this.currentDay) > this.day.size()) {
            this.day_pv.setSelected(this.day.size() - 1);
            this.currentDay = this.formatTimeUnit(this.day.size());
        } else {
            this.day_pv.setSelected(this.currentDay);
        }
        this.selectedCalender.set(5, Integer.parseInt(this.currentDay));
        this.lastMonthDays = this.day.size();
        this.executeAnimator((View)this.day_pv);
        this.day_pv.postDelayed(() -> this.hourChange(), 100L);
    }

    private void hourChange() {
        if ((this.scrollUnits & SCROLL_TYPE.HOUR.value) == SCROLL_TYPE.HOUR.value) {
            this.hour.clear();
            int selectedYear = this.selectedCalender.get(1);
            int selectedMonth = this.selectedCalender.get(2) + 1;
            int selectedDay = this.selectedCalender.get(5);
            if (selectedYear == this.startYear && selectedMonth == this.startMonth && selectedDay == this.startDay) {
                for (int i = this.startHour; i <= 23; ++i) {
                    this.hour.add(this.formatTimeUnit(i));
                }
            } else if (selectedYear == this.endYear && selectedMonth == this.endMonth && selectedDay == this.endDay) {
                for (int i = 0; i <= this.endHour; ++i) {
                    this.hour.add(this.formatTimeUnit(i));
                }
            } else {
                for (int i = 0; i <= 23; ++i) {
                    this.hour.add(this.formatTimeUnit(i));
                }
            }
            this.hour_pv.setData(this.hour);
            if (this.hour.size() < 24 && Integer.valueOf(this.currentHour) > this.hour.size()) {
                this.hour_pv.setSelected(this.hour.size() - 1);
                this.selectedCalender.set(11, this.hour.size());
                this.currentHour = this.formatTimeUnit(this.hour.size());
            } else {
                this.hour_pv.setSelected(this.currentHour);
                this.selectedCalender.set(11, Integer.valueOf(this.currentHour));
            }
            this.executeAnimator((View)this.hour_pv);
        }
        this.hour_pv.postDelayed(new Runnable(){

            @Override
            public void run() {
                CustomDatePicker.this.minuteChange();
            }
        }, 100L);
    }

    private void minuteChange() {
        if ((this.scrollUnits & SCROLL_TYPE.MINUTE.value) == SCROLL_TYPE.MINUTE.value) {
            this.minute.clear();
            int selectedYear = this.selectedCalender.get(1);
            int selectedMonth = this.selectedCalender.get(2) + 1;
            int selectedDay = this.selectedCalender.get(5);
            int selectedHour = this.selectedCalender.get(11);
            if (selectedYear == this.startYear && selectedMonth == this.startMonth && selectedDay == this.startDay && selectedHour == this.startHour) {
                for (int i = this.startMinute; i <= 59; ++i) {
                    this.minute.add(this.formatTimeUnit(i));
                }
            } else if (selectedYear == this.endYear && selectedMonth == this.endMonth && selectedDay == this.endDay && selectedHour == this.endHour) {
                for (int i = 0; i <= this.endMinute; ++i) {
                    this.minute.add(this.formatTimeUnit(i));
                }
            } else {
                for (int i = 0; i <= 59; ++i) {
                    this.minute.add(this.formatTimeUnit(i));
                }
            }
            this.minute_pv.setData(this.minute);
            if (this.minute.size() < 60 && this.minute.size() < Integer.valueOf(this.currentMin)) {
                this.minute_pv.setSelected(this.minute.size() - 1);
                this.selectedCalender.set(12, this.minute.size());
                this.currentMin = this.formatTimeUnit(this.minute.size());
            } else {
                this.minute_pv.setSelected(this.currentMin);
                this.selectedCalender.set(12, Integer.parseInt(this.currentMin));
            }
            this.executeAnimator((View)this.minute_pv);
        }
        this.executeScroll();
    }

    private void executeAnimator(View view) {
        PropertyValuesHolder pvhX = PropertyValuesHolder.ofFloat((String)"alpha", (float[])new float[]{1.0f, 0.0f, 1.0f});
        PropertyValuesHolder pvhY = PropertyValuesHolder.ofFloat((String)"scaleX", (float[])new float[]{1.0f, 1.3f, 1.0f});
        PropertyValuesHolder pvhZ = PropertyValuesHolder.ofFloat((String)"scaleY", (float[])new float[]{1.0f, 1.3f, 1.0f});
        ObjectAnimator.ofPropertyValuesHolder((Object)view, (PropertyValuesHolder[])new PropertyValuesHolder[]{pvhX, pvhY, pvhZ}).setDuration(200L).start();
    }

    private void executeScroll() {
        this.year_pv.setCanScroll(this.year.size() > 1);
        this.month_pv.setCanScroll(this.month.size() > 1);
        this.day_pv.setCanScroll(this.day.size() > 1);
        this.hour_pv.setCanScroll(this.hour.size() > 1 && (this.scrollUnits & SCROLL_TYPE.HOUR.value) == SCROLL_TYPE.HOUR.value);
        this.minute_pv.setCanScroll(this.minute.size() > 1 && (this.scrollUnits & SCROLL_TYPE.MINUTE.value) == SCROLL_TYPE.MINUTE.value);
    }

    private int disScrollUnit(SCROLL_TYPE ... scroll_types) {
        if (scroll_types == null || scroll_types.length == 0) {
            this.scrollUnits = SCROLL_TYPE.DAY.value + SCROLL_TYPE.HOUR.value + SCROLL_TYPE.MINUTE.value;
        } else {
            for (SCROLL_TYPE scroll_type : scroll_types) {
                this.scrollUnits ^= scroll_type.value;
            }
        }
        return this.scrollUnits;
    }

    public void show(String time) {
        if (this.canAccess) {
            if (this.isValidDate(time, "yyyy-MM-dd")) {
                if (this.startCalendar.getTime().getTime() < this.endCalendar.getTime().getTime()) {
                    this.canAccess = true;
                    this.initParameter();
                    this.initTimer();
                    this.addListener();
                    this.setSelectedTime(time);
                    this.datePickerDialog.show();
                }
            } else {
                this.canAccess = false;
            }
        }
    }

    public void showSpecificTime(boolean show) {
        if (this.canAccess) {
            if (show) {
                this.disScrollUnit(new SCROLL_TYPE[0]);
                this.day_pv.setVisibility(0);
                this.day_text.setVisibility(0);
                this.hour_pv.setVisibility(0);
                this.hour_text.setVisibility(0);
                this.minute_pv.setVisibility(0);
                this.minute_text.setVisibility(0);
            } else {
                this.disScrollUnit(SCROLL_TYPE.HOUR, SCROLL_TYPE.MINUTE);
                this.hour_pv.setVisibility(8);
                this.hour_text.setVisibility(8);
                this.minute_pv.setVisibility(8);
                this.minute_text.setVisibility(8);
            }
        }
    }

    public void showDayTime(boolean show) {
        if (this.canAccess && !show) {
            this.day_pv.setVisibility(8);
            this.day_text.setVisibility(8);
        }
    }

    public void setIsLoop(boolean isLoop) {
        if (this.canAccess) {
            this.year_pv.setIsLoop(isLoop);
            this.month_pv.setIsLoop(isLoop);
            this.day_pv.setIsLoop(isLoop);
            this.hour_pv.setIsLoop(isLoop);
            this.minute_pv.setIsLoop(isLoop);
        }
    }

    public void setYearIsLoop(boolean isLoop) {
        if (this.canAccess) {
            this.year_pv.setIsLoop(isLoop);
        }
    }

    public void setMonIsLoop(boolean isLoop) {
        if (this.canAccess) {
            this.month_pv.setIsLoop(isLoop);
        }
    }

    public void setDayIsLoop(boolean isLoop) {
        if (this.canAccess) {
            this.day_pv.setIsLoop(isLoop);
        }
    }

    public void setHourIsLoop(boolean isLoop) {
        if (this.canAccess) {
            this.hour_pv.setIsLoop(isLoop);
        }
    }

    public void setMinIsLoop(boolean isLoop) {
        if (this.canAccess) {
            this.minute_pv.setIsLoop(isLoop);
        }
    }

    public void setSelectedTime(String time) {
        if (this.canAccess) {
            int i;
            int i2;
            String[] str = time.split(" ");
            String[] dateStr = str[0].split("-");
            this.year_pv.setSelected(dateStr[0]);
            this.selectedCalender.set(1, Integer.parseInt(dateStr[0]));
            this.month.clear();
            int selectedYear = this.selectedCalender.get(1);
            if (selectedYear == this.startYear) {
                for (i2 = this.startMonth; i2 <= 12; ++i2) {
                    this.month.add(this.formatTimeUnit(i2));
                }
            } else if (selectedYear == this.endYear) {
                for (i2 = 1; i2 <= this.endMonth; ++i2) {
                    this.month.add(this.formatTimeUnit(i2));
                }
            } else {
                for (i2 = 1; i2 <= 12; ++i2) {
                    this.month.add(this.formatTimeUnit(i2));
                }
            }
            this.month_pv.setData(this.month);
            this.month_pv.setSelected(dateStr[1]);
            this.currentMon = dateStr[1];
            this.selectedCalender.set(2, Integer.parseInt(dateStr[1]) - 1);
            this.executeAnimator((View)this.month_pv);
            this.day.clear();
            int selectedMonth = this.selectedCalender.get(2) + 1;
            if (selectedYear == this.startYear && selectedMonth == this.startMonth) {
                for (i = this.startDay; i <= this.selectedCalender.getActualMaximum(5); ++i) {
                    this.day.add(this.formatTimeUnit(i));
                }
            } else if (selectedYear == this.endYear && selectedMonth == this.endMonth) {
                for (i = 1; i <= this.endDay; ++i) {
                    this.day.add(this.formatTimeUnit(i));
                }
            } else {
                for (i = 1; i <= this.selectedCalender.getActualMaximum(5); ++i) {
                    this.day.add(this.formatTimeUnit(i));
                }
            }
            this.lastMonthDays = this.day.size();
            this.day_pv.setData(this.day);
            this.day_pv.setSelected(dateStr[2]);
            this.currentDay = dateStr[2];
            this.selectedCalender.set(5, Integer.parseInt(dateStr[2]));
            this.executeAnimator((View)this.day_pv);
            if (str.length == 2) {
                int selectedDay;
                String[] timeStr = str[1].split(":");
                if ((this.scrollUnits & SCROLL_TYPE.HOUR.value) == SCROLL_TYPE.HOUR.value) {
                    int i3;
                    this.hour.clear();
                    selectedDay = this.selectedCalender.get(5);
                    if (selectedYear == this.startYear && selectedMonth == this.startMonth && selectedDay == this.startDay) {
                        for (i3 = this.startHour; i3 <= 23; ++i3) {
                            this.hour.add(this.formatTimeUnit(i3));
                        }
                    } else if (selectedYear == this.endYear && selectedMonth == this.endMonth && selectedDay == this.endDay) {
                        for (i3 = 0; i3 <= this.endHour; ++i3) {
                            this.hour.add(this.formatTimeUnit(i3));
                        }
                    } else {
                        for (i3 = 0; i3 <= 23; ++i3) {
                            this.hour.add(this.formatTimeUnit(i3));
                        }
                    }
                    this.hour_pv.setData(this.hour);
                    this.hour_pv.setSelected(timeStr[0]);
                    this.currentHour = timeStr[0];
                    this.selectedCalender.set(11, Integer.parseInt(timeStr[0]));
                    this.executeAnimator((View)this.hour_pv);
                }
                if ((this.scrollUnits & SCROLL_TYPE.MINUTE.value) == SCROLL_TYPE.MINUTE.value) {
                    this.minute.clear();
                    selectedDay = this.selectedCalender.get(5);
                    int selectedHour = this.selectedCalender.get(11);
                    if (selectedYear == this.startYear && selectedMonth == this.startMonth && selectedDay == this.startDay && selectedHour == this.startHour) {
                        for (int i4 = this.startMinute; i4 <= 59; ++i4) {
                            this.minute.add(this.formatTimeUnit(i4));
                        }
                    } else if (selectedYear == this.endYear && selectedMonth == this.endMonth && selectedDay == this.endDay && selectedHour == this.endHour) {
                        for (int i5 = 0; i5 <= this.endMinute; ++i5) {
                            this.minute.add(this.formatTimeUnit(i5));
                        }
                    } else {
                        for (int i6 = 0; i6 <= 59; ++i6) {
                            this.minute.add(this.formatTimeUnit(i6));
                        }
                    }
                    this.minute_pv.setData(this.minute);
                    this.minute_pv.setSelected(timeStr[1]);
                    this.currentMin = timeStr[1];
                    this.selectedCalender.set(12, Integer.parseInt(timeStr[1]));
                    this.executeAnimator((View)this.minute_pv);
                }
            }
            this.executeScroll();
        }
    }

    private boolean isValidDate(String date, String template) {
        boolean convertSuccess = true;
        SimpleDateFormat format = new SimpleDateFormat(template, Locale.CHINA);
        try {
            format.setLenient(false);
            format.parse(date);
        }
        catch (Exception e) {
            convertSuccess = false;
        }
        return convertSuccess;
    }

    public static interface DialogShowOrDismiss {
        public void show();

        public void dismiss();
    }

    public static enum SCROLL_TYPE {
        DAY(1),
        HOUR(2),
        MINUTE(3);

        public int value;

        private SCROLL_TYPE(int value) {
            this.value = value;
        }
    }

    public static interface ResultHandler {
        public void handle(String var1);
    }
}

