/*
 * Decompiled with CFR 0.152.
 */
package com.kangxin.common.byh.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Color;
import android.graphics.drawable.GradientDrawable;
import android.util.AttributeSet;
import com.kangxin.doctor.libdata.R;

public class GradientBackground {
    private int startColor;
    private int endColor;
    private GradientDrawable.Orientation orientation;
    private float radiusCornerTopLeft = 0.0f;
    private float radiusCornerTopRight = 0.0f;
    private float radiusCornerBottomRight = 0.0f;
    private float radiusCornerBottomLeft = 0.0f;

    public GradientBackground(Context context, AttributeSet attrs) {
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.GradientLayout, 0, 0);
        this.startColor = a.getColor(R.styleable.GradientLayout_start_color, -1);
        this.endColor = a.getColor(R.styleable.GradientLayout_end_color, -1);
        this.radiusCornerTopLeft = a.getFloat(R.styleable.GradientLayout_radius_corner_top_left, 0.0f);
        this.radiusCornerTopRight = a.getFloat(R.styleable.GradientLayout_radius_corner_top_right, 0.0f);
        this.radiusCornerBottomLeft = a.getFloat(R.styleable.GradientLayout_radius_corner_bottom_left, 0.0f);
        this.radiusCornerBottomRight = a.getFloat(R.styleable.GradientLayout_radius_corner_bottom_right, 0.0f);
        int attrOrientation = a.getInt(R.styleable.GradientLayout_gradient_orientation, 0);
        this.orientation = this.intToOrientation(attrOrientation);
        a.recycle();
    }

    public GradientBackground setStartColor(int startColor) {
        this.startColor = startColor;
        return this;
    }

    public GradientBackground setEndColor(int endColor) {
        this.endColor = endColor;
        return this;
    }

    public GradientBackground setOrientation(GradientDrawable.Orientation orientation) {
        this.orientation = orientation;
        return this;
    }

    public GradientBackground setRadiusCornerTopLeft(float radius) {
        this.radiusCornerTopLeft = radius;
        return this;
    }

    public GradientBackground setRadiusCornerTopRight(float radius) {
        this.radiusCornerTopRight = radius;
        return this;
    }

    public GradientBackground setRadiusCornerBottomRight(float radius) {
        this.radiusCornerBottomRight = radius;
        return this;
    }

    public GradientBackground setRadiusCornerBottomLeft(float radius) {
        this.radiusCornerBottomLeft = radius;
        return this;
    }

    public GradientDrawable generate() {
        this.populateMissingColors();
        int[] colors = new int[]{this.startColor, this.endColor};
        GradientDrawable.Orientation validOrientation = this.orientation == null ? GradientDrawable.Orientation.TOP_BOTTOM : this.orientation;
        GradientDrawable drawable = new GradientDrawable(validOrientation, colors);
        float[] radii = new float[]{this.radiusCornerTopLeft, this.radiusCornerTopLeft, this.radiusCornerTopRight, this.radiusCornerTopRight, this.radiusCornerBottomRight, this.radiusCornerBottomRight, this.radiusCornerBottomLeft, this.radiusCornerBottomLeft};
        drawable.setCornerRadii(radii);
        return drawable;
    }

    private GradientDrawable.Orientation intToOrientation(int original) {
        switch (original) {
            case 1: {
                return GradientDrawable.Orientation.TR_BL;
            }
            case 2: {
                return GradientDrawable.Orientation.RIGHT_LEFT;
            }
            case 3: {
                return GradientDrawable.Orientation.BR_TL;
            }
            case 4: {
                return GradientDrawable.Orientation.BOTTOM_TOP;
            }
            case 5: {
                return GradientDrawable.Orientation.BL_TR;
            }
            case 6: {
                return GradientDrawable.Orientation.LEFT_RIGHT;
            }
            case 7: {
                return GradientDrawable.Orientation.TL_BR;
            }
        }
        return GradientDrawable.Orientation.TOP_BOTTOM;
    }

    private void populateMissingColors() {
        if (this.endColor == -1 && this.startColor == -1) {
            this.startColor = -1;
        }
        if (this.endColor == -1) {
            this.endColor = this.lighter(this.startColor, 0.5f);
            return;
        }
        if (this.startColor == -1) {
            this.startColor = this.lighter(this.endColor, 0.5f);
        }
    }

    private int lighter(int color2, float factor) {
        int red = (int)(((float)Color.red((int)color2) * (1.0f - factor) / 255.0f + factor) * 255.0f);
        int green = (int)(((float)Color.green((int)color2) * (1.0f - factor) / 255.0f + factor) * 255.0f);
        int blue = (int)(((float)Color.blue((int)color2) * (1.0f - factor) / 255.0f + factor) * 255.0f);
        return Color.argb((int)Color.alpha((int)color2), (int)red, (int)green, (int)blue);
    }
}

