/*
 * Decompiled with CFR 0.152.
 */
package com.kangxin.common.byh.widget;

import android.annotation.TargetApi;
import android.content.Context;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.os.Build;
import android.util.AttributeSet;
import android.widget.LinearLayout;
import com.kangxin.common.byh.widget.GradientBackground;

public class GradientLinearLayout
extends LinearLayout {
    public GradientBackground gradientBackground;

    @TargetApi(value=21)
    public GradientLinearLayout(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.gradientBackground = new GradientBackground(context, attrs);
    }

    @TargetApi(value=11)
    public GradientLinearLayout(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.gradientBackground = new GradientBackground(context, attrs);
    }

    public GradientLinearLayout(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.gradientBackground = new GradientBackground(context, attrs);
    }

    public void setGradientBackgroundConfig(int startColor, int endColor, GradientDrawable.Orientation orientation) {
        this.gradientBackground.setStartColor(startColor).setEndColor(endColor).setOrientation(orientation).generate();
    }

    public GradientLinearLayout setStartColor(int startColor) {
        this.gradientBackground.setStartColor(startColor).generate();
        return this;
    }

    public GradientLinearLayout setEndColor(int endColor) {
        this.gradientBackground.setEndColor(endColor).generate();
        return this;
    }

    public GradientLinearLayout setRadiusCornerTopLeft(float radius) {
        this.gradientBackground.setRadiusCornerTopLeft(radius);
        return this;
    }

    public GradientLinearLayout setRadiusCornerTopRight(float radius) {
        this.gradientBackground.setRadiusCornerTopRight(radius);
        return this;
    }

    public GradientLinearLayout setRadiusCornerBottomRight(float radius) {
        this.gradientBackground.setRadiusCornerBottomRight(radius);
        return this;
    }

    public GradientLinearLayout setRadiusCornerBottomLeft(float radius) {
        this.gradientBackground.setRadiusCornerBottomLeft(radius);
        return this;
    }

    public GradientLinearLayout setOrientation(GradientDrawable.Orientation orientation) {
        this.gradientBackground.setOrientation(orientation).generate();
        return this;
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        super.onLayout(changed, left, top, right, bottom);
        this.setBackground();
    }

    public void setBackground() {
        GradientDrawable background = this.gradientBackground.generate();
        if (Build.VERSION.SDK_INT >= 16) {
            this.setBackground((Drawable)background);
        } else {
            this.setBackgroundDrawable((Drawable)background);
        }
    }
}

