/*
 * Decompiled with CFR 0.152.
 */
package com.kangxin.common.byh.widget;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.text.Editable;
import android.text.TextWatcher;
import android.text.method.DigitsKeyListener;
import android.text.method.KeyListener;
import android.util.AttributeSet;
import androidx.appcompat.widget.AppCompatEditText;
import com.blankj.utilcode.util.RegexUtils;

public class IdCardInputView
extends AppCompatEditText {
    boolean isVerify = false;
    Paint paint = new Paint();
    Rect rect = new Rect();

    public IdCardInputView(Context context) {
        super(context);
    }

    public IdCardInputView(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public IdCardInputView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    private void initPaint() {
        this.paint.setColor(-65536);
        this.paint.setAlpha(180);
        this.paint.setStyle(Paint.Style.STROKE);
        this.paint.setStrokeWidth(4.0f);
        this.paint.setAntiAlias(true);
        this.post(() -> {
            this.rect = new Rect(this.getPaddingLeft() - 10, this.getPaddingTop() - 10, this.getMeasuredWidth() - this.getPaddingEnd() + 10, this.getMeasuredHeight() - this.getPaddingBottom() + 10);
        });
    }

    protected void onFinishInflate() {
        super.onFinishInflate();
        this.initPaint();
        this.setKeyListener((KeyListener)DigitsKeyListener.getInstance((String)"0123456789xX"));
        this.addTextChangedListener(new TextWatcher(){

            public void beforeTextChanged(CharSequence s, int start, int count, int after) {
            }

            public void onTextChanged(CharSequence s, int start, int before, int count) {
                IdCardInputView.this.isVerify = RegexUtils.isIDCard18((CharSequence)s);
                IdCardInputView.this.invalidate();
            }

            public void afterTextChanged(Editable s) {
            }
        });
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        if (!this.isVerify && this.hasFocus()) {
            canvas.drawRect(this.rect, this.paint);
        }
    }

    public String toString() {
        if (this.getText() == null) {
            return "";
        }
        return this.getText().toString().replace("x", "X");
    }

    public boolean isVerify() {
        return this.isVerify;
    }
}

