/*
 * Decompiled with CFR 0.152.
 */
package com.kangxin.common.byh.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.TextView;
import androidx.annotation.Nullable;
import androidx.recyclerview.widget.GridLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import cn.finalteam.galleryfinal.CoreConfig;
import cn.finalteam.galleryfinal.FunctionConfig;
import cn.finalteam.galleryfinal.GalleryFinal;
import cn.finalteam.galleryfinal.ImageLoader;
import cn.finalteam.galleryfinal.ThemeConfig;
import cn.finalteam.galleryfinal.model.PhotoInfo;
import com.chad.library.adapter.base.BaseQuickAdapter;
import com.kangxin.common.byh.adapter.ImageBoxAdapter;
import com.kangxin.common.byh.util.UploadUtils;
import com.kangxin.common.imageloader.GalleryImageLoader;
import com.kangxin.doctor.libdata.R;
import java.util.ArrayList;
import java.util.List;

public class ImageBoxView
extends LinearLayout
implements GalleryFinal.OnHanlderResultCallback {
    String title;
    boolean hasStar;
    TextView numText;
    RecyclerView mRv;
    private ImageBoxAdapter adapter;
    List<String> urlList = new ArrayList<String>();
    TextView hintView;
    private Runnable singleRun;
    TextView bar;
    TextView titleView;
    TextView startView;
    int defaultNum = 0;
    int maxNum = 9;
    boolean hasFootView = true;
    String hint;

    public ImageBoxView(Context context) {
        super(context);
    }

    public ImageBoxView(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.init(context, attrs);
    }

    public ImageBoxView(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context, attrs);
    }

    private void init(Context context, AttributeSet attrs) {
        this.setOrientation(1);
        this.initGalleryConfig();
        this.setBackgroundColor(-1);
        TypedArray typedArray = context.obtainStyledAttributes(attrs, R.styleable.ImageBoxView);
        this.title = typedArray.getString(R.styleable.ImageBoxView_titleNameOut);
        this.hasStar = typedArray.getBoolean(R.styleable.ImageBoxView_hasStarOut, false);
        typedArray.recycle();
        this.setGravity(16);
        LayoutInflater.from((Context)context).inflate(R.layout.imagebox, (ViewGroup)this);
        this.numText = (TextView)this.findViewById(R.id.numText);
        this.mRv = (RecyclerView)this.findViewById(R.id.imageRv);
        this.mRv.setNestedScrollingEnabled(false);
        this.mRv.setHasFixedSize(true);
        this.adapter = new ImageBoxAdapter(new ArrayList<String>());
        this.mRv.setAdapter((RecyclerView.Adapter)this.adapter);
        this.mRv.setLayoutManager((RecyclerView.LayoutManager)new GridLayoutManager(this.getContext(), 4));
        this.adapter.setOnItemChildClickListener(new BaseQuickAdapter.OnItemChildClickListener(){

            public void onItemChildClick(BaseQuickAdapter adapter, View view, int position) {
                adapter.remove(position);
                ImageBoxView.this.remove();
                if (ImageBoxView.this.urlList.get(position) != null) {
                    ImageBoxView.this.urlList.remove(position);
                }
            }
        });
        this.addFootView();
        this.bar = (TextView)this.findViewById(R.id.bar);
        this.titleView = (TextView)this.findViewById(R.id.title);
        this.startView = (TextView)this.findViewById(R.id.star);
        if (this.hasStar) {
            this.startView.setVisibility(0);
        } else {
            this.startView.setVisibility(8);
        }
        this.titleView.setText((CharSequence)this.title);
        this.hintView = (TextView)this.findViewById(R.id.emptyHint);
    }

    public void onHanlderSuccess(int reqeustCode, List<PhotoInfo> resultList) {
        final ArrayList<String> pathList = new ArrayList<String>();
        for (PhotoInfo item : resultList) {
            pathList.add(item.getPhotoPath());
        }
        final ArrayList comUrlList = new ArrayList();
        UploadUtils.upload(pathList, new UploadUtils.Runnable<String>(){

            @Override
            public void run(String strings) {
                ImageBoxView.this.urlList.add(strings);
                comUrlList.add(strings);
                ImageBoxView.this.adapter.addData(strings);
                ImageBoxView.this.addNum();
                if (comUrlList.size() == pathList.size() && ImageBoxView.this.singleRun != null) {
                    ImageBoxView.this.singleRun.run();
                }
            }
        });
    }

    public void onHanlderFailure(int requestCode, String errorMsg) {
    }

    private void addNum() {
        ++this.defaultNum;
        if (this.defaultNum == this.maxNum) {
            this.adapter.removeAllFooterView();
            this.hasFootView = false;
        }
        this.numText.setText((CharSequence)(this.defaultNum + "/9"));
    }

    private void remove() {
        --this.defaultNum;
        this.numText.setText((CharSequence)(this.defaultNum + "/9"));
        if (!this.hasFootView) {
            this.addFootView();
            this.hasFootView = true;
        }
    }

    private void addFootView() {
        View footView = LayoutInflater.from((Context)this.getContext()).inflate(R.layout.imagebox_foot, (ViewGroup)this, false);
        this.adapter.addFooterView(footView);
        footView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                GalleryFinal.openGalleryMuti((int)200, (int)(ImageBoxView.this.maxNum - ImageBoxView.this.defaultNum), (GalleryFinal.OnHanlderResultCallback)ImageBoxView.this);
            }
        });
    }

    public ImageBoxAdapter getAdapter() {
        return this.adapter;
    }

    public List<String> getUrlList() {
        return this.urlList;
    }

    private void initGalleryConfig() {
        GalleryImageLoader imageLoader = new GalleryImageLoader();
        ThemeConfig themeConfig = new ThemeConfig.Builder().build();
        FunctionConfig functionConfig = new FunctionConfig.Builder().setMutiSelectMaxSize(this.maxNum - this.defaultNum).build();
        CoreConfig coreConfig = new CoreConfig.Builder(this.getContext(), (ImageLoader)imageLoader, themeConfig).setFunctionConfig(functionConfig).build();
        GalleryFinal.init((CoreConfig)coreConfig);
    }

    public void bindEmptyHint(String hint) {
        this.hint = hint;
    }

    public void setOnlyShow(List<String> dataList) {
        if (this.numText != null) {
            this.numText.setVisibility(4);
        }
        if (this.startView != null) {
            this.startView.setVisibility(8);
        }
        if (dataList == null || dataList.size() == 0) {
            this.mRv.setVisibility(8);
            this.hintView.setVisibility(0);
            this.hintView.setText((CharSequence)this.hint);
        } else {
            this.mRv.setVisibility(0);
            this.adapter = new ImageBoxAdapter(dataList, false);
            this.mRv.setAdapter((RecyclerView.Adapter)this.adapter);
            this.hintView.setVisibility(4);
        }
        this.post(new Runnable(){

            @Override
            public void run() {
                ImageBoxView.this.bar.setVisibility(8);
                ImageBoxView.this.numText.setVisibility(8);
                ViewGroup vg = (ViewGroup)ImageBoxView.this.startView.getParent();
                vg.setBackgroundColor(0);
                ImageBoxView.this.titleView.setTextSize(2, 16.0f);
            }
        });
    }

    public void injectUploadSucceed(Runnable runnable) {
        this.singleRun = runnable;
    }
}

