/*
 * Decompiled with CFR 0.152.
 */
package com.kangxin.common.byh.widget;

import android.content.Context;
import android.util.AttributeSet;
import android.view.MotionEvent;
import androidx.appcompat.widget.AppCompatEditText;

public class MultInputEdittext
extends AppCompatEditText {
    private int mOffsetHeight;
    private boolean mBottomFlag = false;
    private boolean mCanVerticalScroll;

    public MultInputEdittext(Context context) {
        super(context);
        this.init();
    }

    public MultInputEdittext(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    public MultInputEdittext(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init();
    }

    private void init() {
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        this.mCanVerticalScroll = this.canScrollVertically(-1) || this.canScrollVertically(1);
    }

    public boolean dispatchTouchEvent(MotionEvent event) {
        if (event.getAction() == 0) {
            this.mBottomFlag = false;
        }
        if (this.mBottomFlag) {
            event.setAction(3);
        }
        return super.dispatchTouchEvent(event);
    }

    public boolean onTouchEvent(MotionEvent event) {
        boolean result = super.onTouchEvent(event);
        if (this.mCanVerticalScroll) {
            if (!this.mBottomFlag) {
                this.getParent().requestDisallowInterceptTouchEvent(true);
            }
        } else {
            this.getParent().requestDisallowInterceptTouchEvent(false);
        }
        return result;
    }

    protected void onScrollChanged(int horiz, int vert, int oldHoriz, int oldVert) {
        super.onScrollChanged(horiz, vert, oldHoriz, oldVert);
        if (vert == this.mOffsetHeight || vert == 0) {
            this.getParent().requestDisallowInterceptTouchEvent(false);
            this.mBottomFlag = true;
        }
    }
}

