/*
 * Decompiled with CFR 0.152.
 */
package com.kangxin.common.byh.widget;

import android.content.Context;
import com.blankj.utilcode.util.ToastUtils;
import com.kangxin.common.base.mvp.IBaseProgressView;
import com.kangxin.common.util.GlobeLoadingHelper;
import com.kangxin.common.widget.RxBaseObserver;

public abstract class ProgressObserverOV<T>
extends RxBaseObserver<T> {
    private IBaseProgressView mBaseView;
    private boolean isShowLoading = true;

    public ProgressObserverOV() {
        Context context = this.attachContext();
        if (context instanceof IBaseProgressView) {
            this.mBaseView = (IBaseProgressView)context;
        }
    }

    public ProgressObserverOV(boolean isShowLoading) {
        this.isShowLoading = isShowLoading;
        Context context = this.attachContext();
        if (context instanceof IBaseProgressView) {
            this.mBaseView = (IBaseProgressView)context;
        }
    }

    protected final void onStart() {
        super.onStart();
        if (this.mBaseView != null && this.isShowLoading) {
            this.mBaseView.startReq();
        }
        if (this.isShowLoading && this.mBaseView == null && this.attachContext() != null) {
            GlobeLoadingHelper.show((Context)this.attachContext());
        }
    }

    public final void onReqErr(int code, String msg, String errCode) {
        super.onReqErr(code, msg, errCode);
        ToastUtils.showLong((CharSequence)msg);
        this.reqErr(code, errCode);
        if (this.mBaseView != null && this.isShowLoading) {
            this.mBaseView.endReq();
        }
        if (this.isShowLoading && this.mBaseView == null && this.attachContext() != null) {
            GlobeLoadingHelper.dissmiss();
        }
    }

    public void onError(Throwable e) {
        if (this.mBaseView != null && this.isShowLoading) {
            this.mBaseView.endReq();
        }
        if (this.isShowLoading && this.mBaseView == null && this.attachContext() != null) {
            GlobeLoadingHelper.dissmiss();
        }
    }

    public final void onReqNext(T t) {
        this.next(t);
        if (this.isShowLoading && this.mBaseView == null && this.attachContext() != null) {
            GlobeLoadingHelper.dissmiss();
        }
    }

    public final void destory() {
        this.cancel();
    }

    public final void onComplete() {
        if (this.mBaseView != null) {
            this.mBaseView.endReq();
        }
    }

    protected abstract Context attachContext();

    protected abstract void next(T var1);

    protected abstract void reqErr(int var1, String var2);
}

