/*
 * Decompiled with CFR 0.152.
 */
package com.kangxin.common.byh.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.text.Editable;
import android.text.TextWatcher;
import android.util.AttributeSet;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.EditText;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.kangxin.common.byh.inter.Runnable;
import com.kangxin.doctor.libdata.R;
import io.reactivex.Observer;
import io.reactivex.android.schedulers.AndroidSchedulers;
import io.reactivex.disposables.Disposable;
import io.reactivex.subjects.PublishSubject;
import io.reactivex.subjects.Subject;
import java.util.concurrent.TimeUnit;

public class SearchView
extends FrameLayout {
    EditText inputView;
    ImageView deleteView;
    private Subject<String> stringSubject;
    private Runnable<String> searchBack;
    private String hintStr;
    Disposable d;

    public SearchView(@NonNull Context context) {
        this(context, null);
    }

    public SearchView(@NonNull Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.init(attrs);
    }

    public SearchView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(attrs);
    }

    private void init(AttributeSet attributeSet) {
        TypedArray typedArray = this.getContext().obtainStyledAttributes(attributeSet, R.styleable.SearchView);
        this.hintStr = typedArray.getString(R.styleable.SearchView_defeaultHint);
        typedArray.recycle();
        View contentView = LayoutInflater.from((Context)this.getContext()).inflate(R.layout.lib_usercommon_search_view_layout, (ViewGroup)this, false);
        this.inputView = (EditText)contentView.findViewById(R.id.iv_input);
        this.deleteView = (ImageView)contentView.findViewById(R.id.iv_delete);
        this.creatSubject();
        this.inputView.setHint((CharSequence)this.hintStr);
        this.inputView.addTextChangedListener(new TextWatcher(){

            public void beforeTextChanged(CharSequence s, int start, int count, int after) {
            }

            public void onTextChanged(CharSequence s, int start, int before, int count) {
            }

            public void afterTextChanged(Editable s) {
                if (SearchView.this.inputView.getText().length() == 0) {
                    SearchView.this.deleteView.setVisibility(8);
                } else {
                    SearchView.this.deleteView.setVisibility(0);
                }
                SearchView.this.stringSubject.onNext((Object)s.toString());
            }
        });
        this.deleteView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                SearchView.this.inputView.setText((CharSequence)"");
            }
        });
        this.inputView.setOnEditorActionListener(new TextView.OnEditorActionListener(){

            public boolean onEditorAction(TextView v, int actionId, KeyEvent event) {
                if (actionId == 6) {
                    SearchView.this.inputView.clearFocus();
                    return true;
                }
                return false;
            }
        });
        this.addView(contentView, new ViewGroup.LayoutParams(-1, -2));
    }

    private void creatSubject() {
        this.stringSubject = PublishSubject.create().toSerialized();
        this.stringSubject.ofType(String.class).debounce(300L, TimeUnit.MILLISECONDS).observeOn(AndroidSchedulers.mainThread()).subscribe((Observer)new Observer<String>(){

            public void onSubscribe(Disposable d_) {
                SearchView.this.d = d_;
            }

            public void onNext(String s) {
                if (SearchView.this.searchBack != null) {
                    SearchView.this.searchBack.runnable((Object)s);
                }
            }

            public void onError(Throwable e) {
            }

            public void onComplete() {
            }
        });
    }

    public void setHintStr(@NonNull String hintStr) {
        if (this.inputView != null) {
            this.hintStr = hintStr;
            this.inputView.setHint((CharSequence)hintStr);
        }
    }

    public void cleanText() {
        if (this.inputView != null) {
            this.inputView.getEditableText().clear();
        }
    }

    public void setText(String content) {
        this.inputView.setText((CharSequence)content);
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        if (this.d != null && !this.d.isDisposed()) {
            this.d.dispose();
        }
    }

    public void bindSearchBack(Runnable<String> searchBack) {
        this.searchBack = searchBack;
    }

    public void showSearchIcon(boolean isShow) {
        this.findViewById(R.id.search_icon).setVisibility(isShow ? 0 : 8);
    }
}

