/*
 * Decompiled with CFR 0.152.
 */
package com.kangxin.common.byh.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.BitmapShader;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Shader;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import com.kangxin.doctor.libdata.R;

public class StarBar
extends View {
    private int starDistance = 0;
    private int starCount = 5;
    private int starSize;
    private float starMark = 0.0f;
    private Bitmap starFillBitmap;
    private Drawable starEmptyDrawable;
    private OnStarChangeListener onStarChangeListener;
    private Paint paint;
    private boolean integerMark = false;
    private boolean clickAble = true;

    public StarBar(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context, attrs);
    }

    public StarBar(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context, attrs);
    }

    private void init(Context context, AttributeSet attrs) {
        this.setClickable(true);
        TypedArray mTypedArray = context.obtainStyledAttributes(attrs, R.styleable.StarBar);
        this.starDistance = (int)mTypedArray.getDimension(R.styleable.StarBar_starDistance, 0.0f);
        this.starSize = (int)mTypedArray.getDimension(R.styleable.StarBar_starSize, 20.0f);
        this.starCount = mTypedArray.getInteger(R.styleable.StarBar_starCount, 5);
        this.starEmptyDrawable = mTypedArray.getDrawable(R.styleable.StarBar_starEmpty);
        this.starFillBitmap = this.drawableToBitmap(mTypedArray.getDrawable(R.styleable.StarBar_starFill));
        mTypedArray.recycle();
        this.paint = new Paint();
        this.paint.setAntiAlias(true);
        this.paint.setShader((Shader)new BitmapShader(this.starFillBitmap, Shader.TileMode.CLAMP, Shader.TileMode.CLAMP));
    }

    public void setClickAble(boolean clickAble) {
        this.clickAble = clickAble;
    }

    public void setIntegerMark(boolean integerMark) {
        this.integerMark = integerMark;
    }

    public void setStarMark(float mark) {
        this.starMark = this.integerMark ? (float)((int)Math.ceil(mark)) : (float)Math.round(mark * 10.0f) * 1.0f / 10.0f;
        if (this.onStarChangeListener != null) {
            this.onStarChangeListener.onStarChange(this.starMark);
        }
        this.invalidate();
    }

    public float getStarMark() {
        return this.starMark;
    }

    public void setOnStarChangeListener(OnStarChangeListener onStarChangeListener) {
        this.onStarChangeListener = onStarChangeListener;
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        this.setMeasuredDimension(this.starSize * this.starCount + this.starDistance * (this.starCount - 1), this.starSize);
    }

    protected void onDraw(Canvas canvas) {
        int i;
        super.onDraw(canvas);
        if (this.starFillBitmap == null || this.starEmptyDrawable == null) {
            return;
        }
        for (i = 0; i < this.starCount; ++i) {
            this.starEmptyDrawable.setBounds((this.starDistance + this.starSize) * i, 0, (this.starDistance + this.starSize) * i + this.starSize, this.starSize);
            this.starEmptyDrawable.draw(canvas);
        }
        if (this.starMark > 1.0f) {
            canvas.drawRect(0.0f, 0.0f, (float)this.starSize, (float)this.starSize, this.paint);
            if (this.starMark - (float)((int)this.starMark) == 0.0f) {
                i = 1;
                while ((float)i < this.starMark) {
                    canvas.translate((float)(this.starDistance + this.starSize), 0.0f);
                    canvas.drawRect(0.0f, 0.0f, (float)this.starSize, (float)this.starSize, this.paint);
                    ++i;
                }
            } else {
                i = 1;
                while ((float)i < this.starMark - 1.0f) {
                    canvas.translate((float)(this.starDistance + this.starSize), 0.0f);
                    canvas.drawRect(0.0f, 0.0f, (float)this.starSize, (float)this.starSize, this.paint);
                    ++i;
                }
                canvas.translate((float)(this.starDistance + this.starSize), 0.0f);
                canvas.drawRect(0.0f, 0.0f, (float)this.starSize * ((float)Math.round((this.starMark - (float)((int)this.starMark)) * 10.0f) * 1.0f / 10.0f), (float)this.starSize, this.paint);
            }
        } else {
            canvas.drawRect(0.0f, 0.0f, (float)this.starSize * this.starMark, (float)this.starSize, this.paint);
        }
    }

    public void setStarCount(int count) {
        this.starCount = count;
    }

    public void setRating(int rating) {
        this.starMark = this.integerMark ? (float)((int)Math.ceil(rating)) : (float)Math.round(rating * 10) * 1.0f / 10.0f;
        if (this.onStarChangeListener != null) {
            this.onStarChangeListener.onStarChange(this.starMark);
        }
        this.invalidate();
    }

    public boolean onTouchEvent(MotionEvent event) {
        if (this.clickAble) {
            int x = (int)event.getX();
            if (x < 0) {
                x = 0;
            }
            if (x > this.getMeasuredWidth()) {
                x = this.getMeasuredWidth();
            }
            switch (event.getAction()) {
                case 0: {
                    this.setStarMark((float)x * 1.0f / ((float)this.getMeasuredWidth() * 1.0f / (float)this.starCount));
                    break;
                }
                case 2: {
                    this.setStarMark((float)x * 1.0f / ((float)this.getMeasuredWidth() * 1.0f / (float)this.starCount));
                    break;
                }
            }
            this.invalidate();
        }
        return super.onTouchEvent(event);
    }

    private Bitmap drawableToBitmap(Drawable drawable) {
        if (drawable == null) {
            return null;
        }
        Bitmap bitmap = Bitmap.createBitmap((int)this.starSize, (int)this.starSize, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(bitmap);
        drawable.setBounds(0, 0, this.starSize, this.starSize);
        drawable.draw(canvas);
        return bitmap;
    }

    public static interface OnStarChangeListener {
        public void onStarChange(float var1);
    }
}

