/*
 * Decompiled with CFR 0.152.
 */
package com.kangxin.common.byh.widget;

import android.content.Context;
import android.graphics.Color;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.ScrollView;
import android.widget.TextView;
import android.widget.Toast;
import androidx.gridlayout.widget.GridLayout;
import com.blankj.utilcode.util.ScreenUtils;
import com.blankj.utilcode.util.SizeUtils;
import com.blankj.utilcode.util.TimeUtils;
import com.kangxin.common.byh.entity.SubscribeTimeEntity;
import com.kangxin.common.util.StringsUtils;
import com.kangxin.doctor.libdata.R;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class SubscribeTimeView
extends LinearLayout {
    private Context mContext;
    List<String> dates;
    ArrayList<String> weekDays;
    LinearLayout selectedTime;
    private String selectedDate;
    private OnDateClickListener listener;
    List<SubscribeTimeEntity> timeEntities;

    public SubscribeTimeView(Context context) {
        this(context, null);
    }

    public SubscribeTimeView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public SubscribeTimeView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.mContext = context;
        this.setOrientation(1);
        LinearLayout.LayoutParams params = new LinearLayout.LayoutParams(-1, -2);
        this.setLayoutParams((ViewGroup.LayoutParams)params);
        this.setBackgroundColor(Color.parseColor((String)"#f8f8f8"));
    }

    private void initTimeView() {
        ScrollView scrollView = new ScrollView(this.mContext);
        GridLayout gridLayout = new GridLayout(this.mContext);
        gridLayout.setColumnCount(4);
        gridLayout.setRowCount(4);
        gridLayout.setOrientation(0);
        LinearLayout.LayoutParams layoutParams = new LinearLayout.LayoutParams(-1, -1);
        layoutParams.setMargins(5, 5, 5, 5);
        scrollView.addView((View)gridLayout, (ViewGroup.LayoutParams)layoutParams);
        this.addView((View)scrollView, (ViewGroup.LayoutParams)layoutParams);
        for (int i = 0; i < this.timeEntities.size(); ++i) {
            LinearLayout linearLayout = new LinearLayout(this.mContext);
            linearLayout.setOrientation(1);
            LinearLayout.LayoutParams linLp = new LinearLayout.LayoutParams((ScreenUtils.getScreenWidth() - SizeUtils.dp2px((float)40.0f)) / 4, SizeUtils.dp2px((float)50.0f));
            linearLayout.setLayoutParams((ViewGroup.LayoutParams)linLp);
            linLp.setMargins(12, 12, 12, 12);
            TextView timeText = new TextView(this.mContext);
            String consultationTime = this.timeEntities.get(i).getConsultationTime();
            String substring = consultationTime.substring(0, 5);
            timeText.setText((CharSequence)substring);
            LinearLayout.LayoutParams timeParams = new LinearLayout.LayoutParams(-2, -2);
            timeParams.leftMargin = SizeUtils.dp2px((float)4.0f);
            timeParams.topMargin = SizeUtils.dp2px((float)4.0f);
            timeText.setLayoutParams((ViewGroup.LayoutParams)timeParams);
            linearLayout.addView((View)timeText);
            TextView statusView = new TextView(this.mContext);
            this.fullStatus(statusView, this.timeEntities.get(i).getTotal(), this.timeEntities.get(i).getConsultationTime());
            LinearLayout.LayoutParams statusParams = new LinearLayout.LayoutParams(-2, -2);
            statusParams.gravity = 85;
            statusParams.rightMargin = SizeUtils.dp2px((float)4.0f);
            timeParams.bottomMargin = SizeUtils.dp2px((float)4.0f);
            statusView.setLayoutParams((ViewGroup.LayoutParams)statusParams);
            linearLayout.addView((View)statusView);
            linearLayout.setPadding(0, SizeUtils.dp2px((float)2.0f), 0, SizeUtils.dp2px((float)2.0f));
            if (this.isTimeOut(this.timeEntities.get(i).getConsultationTime())) {
                statusView.setTextColor(Color.parseColor((String)"#999999"));
                timeText.setTextColor(Color.parseColor((String)"#999999"));
                statusView.setText((CharSequence)StringsUtils.getString((int)R.string.commbyh_yiguo));
                linearLayout.setBackground(this.getResources().getDrawable(R.drawable.commbyh_by_background_circle_gray));
                linearLayout.setOnClickListener(v -> Toast.makeText((Context)this.mContext, (CharSequence)StringsUtils.getString((int)R.string.commbyh_chaoshibuyunxuxuanze), (int)0).show());
            } else {
                statusView.setTextColor(Color.parseColor((String)"#999999"));
                timeText.setTextColor(Color.parseColor((String)"#333333"));
                this.fullStatus(statusView, this.timeEntities.get(i).getTotal(), this.timeEntities.get(i).getConsultationTime());
                linearLayout.setBackground(this.getResources().getDrawable(R.drawable.by_background_circle_white_gray));
                int finalI = i;
                linearLayout.setOnClickListener(v -> {
                    this.timeSelected(linearLayout);
                    if (this.listener != null) {
                        this.listener.onClickTime(this.timeEntities.get(finalI).getConsultationTime());
                    }
                });
            }
            GridLayout.Spec rowSpec = GridLayout.spec((int)(i / 4), (float)1.0f);
            GridLayout.Spec columnSpec = GridLayout.spec((int)(i % 4), (float)1.0f);
            GridLayout.LayoutParams gridParams = new GridLayout.LayoutParams(rowSpec, columnSpec);
            gridParams.height = 0;
            gridParams.width = 0;
            gridParams.setMargins(SizeUtils.dp2px((float)2.0f), SizeUtils.dp2px((float)2.0f), SizeUtils.dp2px((float)2.0f), SizeUtils.dp2px((float)2.0f));
            gridLayout.addView((View)linearLayout, (ViewGroup.LayoutParams)linLp);
        }
    }

    private void timeSelected(LinearLayout linearLayout) {
        if (this.selectedTime == null) {
            this.selectedTime = linearLayout;
            TextView statusView = (TextView)linearLayout.getChildAt(1);
            statusView.setTextColor(-1);
            TextView timeText = (TextView)linearLayout.getChildAt(0);
            timeText.setTextColor(-1);
            linearLayout.setBackground(this.getResources().getDrawable(R.drawable.by_background_circle_blue));
        } else {
            if (linearLayout == this.selectedTime) {
                return;
            }
            TextView statusView = (TextView)this.selectedTime.getChildAt(1);
            TextView timeText = (TextView)this.selectedTime.getChildAt(0);
            statusView.setTextColor(-16777216);
            timeText.setTextColor(-16777216);
            this.selectedTime.setBackground(this.getResources().getDrawable(R.drawable.by_background_circle_white_gray));
            TextView statusView1 = (TextView)linearLayout.getChildAt(1);
            statusView1.setTextColor(-1);
            TextView timeText1 = (TextView)linearLayout.getChildAt(0);
            timeText1.setTextColor(-1);
            linearLayout.setBackground(this.getResources().getDrawable(R.drawable.by_background_circle_blue));
            this.selectedTime = linearLayout;
        }
    }

    private boolean isTimeOut(String consultationTime) {
        consultationTime = this.selectedDate + " " + consultationTime;
        long l = TimeUtils.string2Millis((String)consultationTime, (DateFormat)new SimpleDateFormat("yyyy-MM-dd HH:mm:ss"));
        long nowMills = TimeUtils.getNowMills();
        long l1 = nowMills - l;
        return l1 > 0L;
    }

    private void fullStatus(TextView statusView, int total, String consultationTime) {
        statusView.setText((CharSequence)(StringsUtils.getString((int)R.string.commbyh_yiyue) + total));
    }

    private void initDateView() {
        LinearLayout timeLayout = new LinearLayout(this.mContext);
        LinearLayout.LayoutParams timeParams = new LinearLayout.LayoutParams(-1, -2);
        timeParams.leftMargin = SizeUtils.dp2px((float)8.0f);
        timeParams.rightMargin = SizeUtils.dp2px((float)8.0f);
        timeLayout.setLayoutParams((ViewGroup.LayoutParams)timeParams);
        int i = 0;
        while (i < this.dates.size()) {
            LinearLayout dateLayout = new LinearLayout(this.mContext);
            LinearLayout.LayoutParams params = new LinearLayout.LayoutParams(0, -2, 1.0f);
            params.leftMargin = SizeUtils.dp2px((float)5.0f);
            dateLayout.setLayoutParams((ViewGroup.LayoutParams)params);
            TextView weekView = new TextView(this.mContext);
            TextView dateView = new TextView(this.mContext);
            weekView.setText((CharSequence)this.weekDays.get(i));
            dateView.setText((CharSequence)this.dates.get(i).substring(5));
            dateView.setTextSize(12.0f);
            weekView.setGravity(17);
            dateView.setGravity(17);
            weekView.setTextColor(-16777216);
            dateView.setTextColor(-16777216);
            dateLayout.setOrientation(1);
            dateLayout.addView((View)weekView, -2, -2);
            dateLayout.addView((View)dateView, -2, -2);
            LinearLayout.LayoutParams layoutParams = new LinearLayout.LayoutParams(0, -2, 1.0f);
            layoutParams.leftMargin = SizeUtils.dp2px((float)8.0f);
            final int finalI = i++;
            dateLayout.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    SubscribeTimeView.this.selectedDate = SubscribeTimeView.this.dates.get(finalI);
                    SubscribeTimeView.this.dateSelect(finalI);
                    if (SubscribeTimeView.this.listener != null) {
                        SubscribeTimeView.this.listener.onClickDate(SubscribeTimeView.this.dates.get(finalI));
                    }
                }
            });
            timeLayout.setBackgroundColor(-1);
            timeLayout.addView((View)dateLayout, (ViewGroup.LayoutParams)layoutParams);
        }
        timeLayout.setPadding(0, SizeUtils.dp2px((float)5.0f), 0, SizeUtils.dp2px((float)5.0f));
        timeParams.leftMargin = SizeUtils.dp2px((float)2.0f);
        this.addView((View)timeLayout, -1, -2);
        this.dateSelect(0);
    }

    private void dateSelect(int position) {
        LinearLayout timeLayout = (LinearLayout)this.getChildAt(0);
        for (int i = 0; i < timeLayout.getChildCount(); ++i) {
            LinearLayout date = (LinearLayout)timeLayout.getChildAt(i);
            TextView weekView = (TextView)date.getChildAt(0);
            TextView dateView = (TextView)date.getChildAt(1);
            weekView.setTextColor(-16777216);
            dateView.setTextColor(-16777216);
        }
        LinearLayout date = (LinearLayout)timeLayout.getChildAt(position);
        TextView weekView = (TextView)date.getChildAt(0);
        TextView dateView = (TextView)date.getChildAt(1);
        weekView.setTextColor(Color.parseColor((String)"#3576E0"));
        dateView.setTextColor(Color.parseColor((String)"#3576E0"));
        this.selectedDate = this.dates.get(position);
    }

    private void initDefaultDate() {
        this.initWeekDate();
    }

    private void initTimeEntities() {
        this.timeEntities = new ArrayList<SubscribeTimeEntity>();
        for (int i = 0; i < 18; ++i) {
            SubscribeTimeEntity subscribeTimeEntity = new SubscribeTimeEntity();
            subscribeTimeEntity.setConsultationTime("11:00:00");
            subscribeTimeEntity.setTotal(1);
            this.timeEntities.add(subscribeTimeEntity);
        }
    }

    private void initWeekDate() {
        this.weekDays = new ArrayList();
        for (int i = 0; i < this.dates.size(); ++i) {
            this.weekDays.add(this.caculateWeek(this.dates.get(i)));
        }
    }

    private String caculateWeek(String date) {
        String chineseWeek = TimeUtils.getChineseWeek((Date)TimeUtils.string2Date((String)date, (DateFormat)new SimpleDateFormat("yyyy-MM-dd")));
        return chineseWeek;
    }

    public void setListener(OnDateClickListener listener) {
        this.listener = listener;
    }

    public void bindDate(List<String> listResponseBody) {
        this.dates = listResponseBody;
        this.initWeekDate();
        this.initDateView();
        this.selectedDate = this.dates.get(0);
    }

    public void bindTime(List<SubscribeTimeEntity> result) {
        this.timeEntities = result;
        int childCount = this.getChildCount();
        if (childCount == 2) {
            this.removeViewAt(1);
        }
        this.initTimeView();
    }

    public static interface OnDateClickListener {
        public void onClickDate(String var1);

        public void onClickTime(String var1);
    }
}

