/*
 * Decompiled with CFR 0.152.
 */
package com.kangxin.common.byh.widget;

import android.content.Context;
import android.util.AttributeSet;
import android.view.View;
import android.widget.ImageView;
import android.widget.TextView;
import com.kangxin.common.Pretty;
import com.kangxin.common.byh.entity.EducationExperciseEneity;
import com.kangxin.common.byh.entity.WorkExperciseEntity;
import com.kangxin.common.byh.util.TimeUtil;
import com.kangxin.common.util.StringsUtils;
import com.kangxin.doctor.libdata.R;
import com.kangxin.widget.common.FoldLayout;
import java.util.List;

public class WorkExperciseFoldLayout
extends FoldLayout {
    public WorkExperciseFoldLayout(Context context) {
        this(context, null);
    }

    public WorkExperciseFoldLayout(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public WorkExperciseFoldLayout(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    public void setAdapter(List<?> datas) {
        this.setAdapter(R.layout.by_item_school, datas);
    }

    protected void dispatchChildView(View itemView, Object o) {
        ImageView schoolIcon = (ImageView)itemView.findViewById(R.id.expert_school_icon);
        TextView schoolName = (TextView)itemView.findViewById(R.id.expert_school_name);
        TextView schoolDep = (TextView)itemView.findViewById(R.id.expert_school_dep);
        TextView expertStartEndTime = (TextView)itemView.findViewById(R.id.expertStartEndTime);
        if (o instanceof WorkExperciseEntity) {
            WorkExperciseEntity entity = (WorkExperciseEntity)o;
            Pretty.create().loadImage(entity.getHospitalLogo()).bitmapTransform(2).placeholder(R.mipmap.ic_work_experience).into(schoolIcon);
            schoolName.setText((CharSequence)entity.getHospitalName());
            schoolDep.setText((CharSequence)entity.getStdSecondDeptName());
            String startTimeStr = TimeUtil.dateToStamp((String)entity.getStartTime());
            String endTimeStr = TimeUtil.dateToStamp((String)entity.getEndTime());
            if (!startTimeStr.isEmpty() && !endTimeStr.isEmpty()) {
                expertStartEndTime.setText((CharSequence)(startTimeStr + StringsUtils.getString((int)R.string.commbyh__zhi_) + endTimeStr));
            }
        } else if (o instanceof EducationExperciseEneity) {
            EducationExperciseEneity eneity = (EducationExperciseEneity)o;
            Pretty.create().loadImage(eneity.getSchoolLogo()).bitmapTransform(2).placeholder(R.mipmap.ic_work_experience).into(schoolIcon);
            schoolName.setText((CharSequence)String.format("%s", eneity.getSchoolName()));
            schoolDep.setText((CharSequence)String.format("%s", eneity.getEducationName()));
            if (eneity.getStartTime() != null && eneity.getEndTime() != null && eneity.getStartTime().length() > 11 && eneity.getEndTime().length() > 11) {
                expertStartEndTime.setText((CharSequence)String.format(StringsUtils.getString((int)R.string.commbyh__s_zhi__s), TimeUtil.dateToStamp((String)eneity.getStartTime()), TimeUtil.dateToStamp((String)eneity.getEndTime())));
            }
        }
    }
}

