/*
 * Decompiled with CFR 0.152.
 */
package com.kangxin.common.byh.widget.cameraforid;

import android.annotation.TargetApi;
import android.content.Context;
import android.hardware.Camera;
import android.util.AttributeSet;
import android.util.Log;
import android.view.SurfaceHolder;
import android.view.SurfaceView;
import com.kangxin.common.byh.widget.cameraforid.CameraUtils;
import java.util.List;

public class CameraPreview
extends SurfaceView
implements SurfaceHolder.Callback {
    private static String TAG = CameraPreview.class.getName();
    private Camera camera;

    public CameraPreview(Context context) {
        super(context);
        this.init();
    }

    public CameraPreview(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    public CameraPreview(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init();
    }

    @TargetApi(value=21)
    public CameraPreview(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.init();
    }

    private void init() {
        SurfaceHolder surfaceHolder = this.getHolder();
        surfaceHolder.addCallback((SurfaceHolder.Callback)this);
        surfaceHolder.setKeepScreenOn(true);
        surfaceHolder.setType(3);
    }

    public void surfaceCreated(SurfaceHolder holder) {
        this.camera = CameraUtils.openCamera();
        if (this.camera != null) {
            try {
                this.camera.setPreviewDisplay(holder);
                Camera.Parameters parameters = this.camera.getParameters();
                if (this.getResources().getConfiguration().orientation == 1) {
                    this.camera.setDisplayOrientation(90);
                    parameters.setRotation(90);
                } else {
                    this.camera.setDisplayOrientation(0);
                    parameters.setRotation(0);
                }
                Camera.Size bestSize = this.getBestSize(parameters.getSupportedPreviewSizes());
                if (bestSize != null) {
                    parameters.setPreviewSize(bestSize.width, bestSize.height);
                    parameters.setPictureSize(bestSize.width, bestSize.height);
                } else {
                    parameters.setPreviewSize(1920, 1080);
                    parameters.setPictureSize(1920, 1080);
                }
                this.camera.setParameters(parameters);
                this.camera.startPreview();
                this.focus();
            }
            catch (Exception e) {
                Log.d((String)TAG, (String)("Error setting camera preview: " + e.getMessage()));
                try {
                    Camera.Parameters parameters = this.camera.getParameters();
                    if (this.getResources().getConfiguration().orientation == 1) {
                        this.camera.setDisplayOrientation(90);
                        parameters.setRotation(90);
                    } else {
                        this.camera.setDisplayOrientation(0);
                        parameters.setRotation(0);
                    }
                    this.camera.setParameters(parameters);
                    this.camera.startPreview();
                    this.focus();
                }
                catch (Exception e1) {
                    e.printStackTrace();
                    this.camera = null;
                }
            }
        }
    }

    public void surfaceChanged(SurfaceHolder holder, int format, int w, int h) {
    }

    public void surfaceDestroyed(SurfaceHolder holder) {
        this.release();
    }

    private Camera.Size getBestSize(List<Camera.Size> sizes) {
        Camera.Size bestSize = null;
        for (Camera.Size size : sizes) {
            if ((float)size.width / (float)size.height != 1.7777778f) continue;
            if (bestSize == null) {
                bestSize = size;
                continue;
            }
            if (size.width <= bestSize.width) continue;
            bestSize = size;
        }
        return bestSize;
    }

    private void release() {
        if (this.camera != null) {
            this.camera.stopPreview();
            this.camera.release();
            this.camera = null;
        }
    }

    public void focus() {
        if (this.camera != null) {
            this.camera.autoFocus(null);
        }
    }

    public boolean switchFlashLight() {
        if (this.camera != null) {
            Camera.Parameters parameters = this.camera.getParameters();
            if (parameters.getFlashMode().equals("off")) {
                parameters.setFlashMode("torch");
                this.camera.setParameters(parameters);
                return true;
            }
            parameters.setFlashMode("off");
            this.camera.setParameters(parameters);
            return false;
        }
        return false;
    }

    public void takePhoto(Camera.PictureCallback pictureCallback) {
        if (this.camera != null) {
            this.camera.takePicture(null, null, pictureCallback);
        }
    }

    public void startPreview() {
        if (this.camera != null) {
            this.camera.startPreview();
        }
    }
}

