/*
 * Decompiled with CFR 0.152.
 */
package com.kangxin.common.byh.widget.photoSelect;

import android.content.Context;
import android.net.Uri;
import android.text.TextUtils;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.recyclerview.widget.RecyclerView;
import com.bumptech.glide.Glide;
import com.bumptech.glide.RequestBuilder;
import com.bumptech.glide.load.engine.DiskCacheStrategy;
import com.kangxin.common.byh.widget.photoSelect.OnItemLongClickListener;
import com.kangxin.doctor.libdata.R;
import com.luck.picture.lib.config.PictureMimeType;
import com.luck.picture.lib.entity.LocalMedia;
import com.luck.picture.lib.listener.OnItemClickListener;
import com.luck.picture.lib.tools.DateUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class GridImageAdapter
extends RecyclerView.Adapter<ViewHolder> {
    public static final String TAG = "PictureSelector";
    public static final int TYPE_CAMERA = 1;
    public static final int TYPE_PICTURE = 2;
    private LayoutInflater mInflater;
    private List<LocalMedia> list = new ArrayList<LocalMedia>();
    private int selectMax = 9;
    private onAddPicClickListener mOnAddPicClickListener;
    private OnItemClickListener mItemClickListener;
    private OnItemLongClickListener mItemLongClickListener;

    public void delete(int position) {
        try {
            if (position != -1 && this.list.size() > position) {
                this.list.remove(position);
                this.notifyItemRemoved(position);
                this.notifyItemRangeChanged(position, this.list.size());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public GridImageAdapter(Context context, onAddPicClickListener mOnAddPicClickListener) {
        this.mInflater = LayoutInflater.from((Context)context);
        this.mOnAddPicClickListener = mOnAddPicClickListener;
    }

    public void setSelectMax(int selectMax) {
        this.selectMax = selectMax;
    }

    public void setList(List<LocalMedia> list) {
        this.list = list;
    }

    public List<LocalMedia> getData() {
        return this.list == null ? new ArrayList() : this.list;
    }

    public void remove(int position) {
        if (this.list != null) {
            this.list.remove(position);
        }
    }

    public int getItemCount() {
        if (this.list.size() < this.selectMax) {
            return this.list.size() + 1;
        }
        return this.list.size();
    }

    public int getItemViewType(int position) {
        if (this.isShowAddItem(position)) {
            return 1;
        }
        return 2;
    }

    public ViewHolder onCreateViewHolder(ViewGroup viewGroup, int i) {
        View view = this.mInflater.inflate(R.layout.gv_filter_image, viewGroup, false);
        ViewHolder viewHolder = new ViewHolder(view);
        return viewHolder;
    }

    private boolean isShowAddItem(int position) {
        int size = this.list.size() == 0 ? 0 : this.list.size();
        return position == size;
    }

    public void onBindViewHolder(ViewHolder viewHolder, int position) {
        if (this.getItemViewType(position) == 1) {
            viewHolder.mImg.setImageResource(R.drawable.ic_xiangji);
            viewHolder.mImg.setPadding(50, 50, 50, 50);
            viewHolder.mImg.setOnClickListener(v -> this.mOnAddPicClickListener.onAddPicClick());
            viewHolder.mIvDel.setVisibility(4);
        } else {
            viewHolder.mIvDel.setVisibility(0);
            viewHolder.mIvDel.setOnClickListener(view -> {
                int index = viewHolder.getAdapterPosition();
                if (index != -1 && this.list.size() > index) {
                    this.list.remove(index);
                    this.notifyItemRemoved(index);
                    this.notifyItemRangeChanged(index, this.list.size());
                }
            });
            LocalMedia media = this.list.get(position);
            if (media == null || TextUtils.isEmpty((CharSequence)media.getPath())) {
                return;
            }
            int chooseModel = media.getChooseModel();
            String path = media.isCut() && !media.isCompressed() ? media.getCutPath() : (media.isCompressed() || media.isCut() && media.isCompressed() ? media.getCompressPath() : media.getPath());
            Log.i((String)TAG, (String)("\u539f\u56fe\u5730\u5740::" + media.getPath()));
            if (media.isCut()) {
                Log.i((String)TAG, (String)("\u88c1\u526a\u5730\u5740::" + media.getCutPath()));
            }
            if (media.isCompressed()) {
                Log.i((String)TAG, (String)("\u538b\u7f29\u5730\u5740::" + media.getCompressPath()));
                Log.i((String)TAG, (String)("\u538b\u7f29\u540e\u6587\u4ef6\u5927\u5c0f::" + new File(media.getCompressPath()).length() / 1024L + "k"));
            }
            if (!TextUtils.isEmpty((CharSequence)media.getAndroidQToPath())) {
                Log.i((String)TAG, (String)("Android Q\u7279\u6709\u5730\u5740::" + media.getAndroidQToPath()));
            }
            if (media.isOriginal()) {
                Log.i((String)TAG, (String)"\u662f\u5426\u5f00\u542f\u539f\u56fe\u529f\u80fd::true");
                Log.i((String)TAG, (String)("\u5f00\u542f\u539f\u56fe\u529f\u80fd\u540e\u5730\u5740::" + media.getOriginalPath()));
            }
            long duration = media.getDuration();
            viewHolder.tvDuration.setVisibility(PictureMimeType.eqVideo((String)media.getMimeType()) ? 0 : 8);
            if (chooseModel == PictureMimeType.ofAudio()) {
                viewHolder.tvDuration.setVisibility(0);
                viewHolder.tvDuration.setCompoundDrawablesRelativeWithIntrinsicBounds(R.drawable.picture_icon_audio, 0, 0, 0);
            } else {
                viewHolder.tvDuration.setCompoundDrawablesRelativeWithIntrinsicBounds(R.drawable.picture_icon_video, 0, 0, 0);
            }
            viewHolder.tvDuration.setText((CharSequence)DateUtils.formatDurationTime((long)duration));
            if (chooseModel == PictureMimeType.ofAudio()) {
                viewHolder.mImg.setImageResource(R.drawable.picture_audio_placeholder);
            } else {
                ((RequestBuilder)((RequestBuilder)((RequestBuilder)Glide.with((Context)viewHolder.itemView.getContext()).load(PictureMimeType.isContent((String)path) && !media.isCut() && !media.isCompressed() ? Uri.parse((String)path) : path).centerCrop()).placeholder(R.color.app_color_f6)).diskCacheStrategy(DiskCacheStrategy.ALL)).into(viewHolder.mImg);
            }
            if (this.mItemClickListener != null) {
                viewHolder.itemView.setOnClickListener(v -> {
                    int adapterPosition = viewHolder.getAdapterPosition();
                    this.mItemClickListener.onItemClick(v, adapterPosition);
                });
            }
            if (this.mItemLongClickListener != null) {
                viewHolder.itemView.setOnLongClickListener(v -> {
                    int adapterPosition = viewHolder.getAdapterPosition();
                    this.mItemLongClickListener.onItemLongClick(viewHolder, adapterPosition, v);
                    return true;
                });
            }
        }
    }

    public void setOnItemClickListener(OnItemClickListener l) {
        this.mItemClickListener = l;
    }

    public void setItemLongClickListener(OnItemLongClickListener l) {
        this.mItemLongClickListener = l;
    }

    public class ViewHolder
    extends RecyclerView.ViewHolder {
        ImageView mImg;
        ImageView mIvDel;
        TextView tvDuration;

        public ViewHolder(View view) {
            super(view);
            this.mImg = (ImageView)view.findViewById(R.id.fiv);
            this.mIvDel = (ImageView)view.findViewById(R.id.iv_del);
            this.tvDuration = (TextView)view.findViewById(R.id.tv_duration);
        }
    }

    public static interface onAddPicClickListener {
        public void onAddPicClick();
    }
}

