/*
 * Decompiled with CFR 0.152.
 */
package com.kangxin.doctor.libdata.http.db;

import android.content.ContentValues;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import com.kangxin.doctor.libdata.http.bean.ConversationBean;
import com.kangxin.doctor.libdata.http.db.MyDBHelper;
import com.kangxin.util.common.LogUtils;
import java.util.List;

public class ConversationDao {
    private static String[] attributes = new String[]{"uuid", "name", "type", "logoUrl"};
    private static MyDBHelper mMyDBHelper;
    private static ConversationDao conversationDao;

    public static synchronized ConversationDao getInstance() {
        mMyDBHelper = MyDBHelper.myDBHelper;
        if (conversationDao == null) {
            conversationDao = new ConversationDao();
        }
        return conversationDao;
    }

    public synchronized void insertOrUpdateInfo(ConversationBean bean) {
        int resultNum = this.updateConversationInfo(bean);
        if (resultNum <= 0) {
            this.insertInfo(bean);
        }
    }

    public synchronized void insertInfo(ConversationBean bean) {
        SQLiteDatabase db = mMyDBHelper.getDB();
        ContentValues values = new ContentValues();
        values.put(attributes[0], bean.getUuid());
        values.put(attributes[1], bean.getName());
        values.put(attributes[2], bean.getType() + "");
        values.put(attributes[3], bean.getLogoUrl());
        long result = db.insert("ConversationDao", null, values);
        LogUtils.d((Object)("\u83b7\u53d6\u66f4\u65b0\u7684\u6570\u636e(\u63d2\u5165\u6570\u636e)ConversationDao" + String.valueOf(result)));
    }

    public synchronized void insertMultiConversationInfo(List<ConversationBean> data) {
        if (data == null || data.size() == 0) {
            return;
        }
        for (int i = 0; i < data.size(); ++i) {
            ConversationBean bean = data.get(i);
            this.insertOrUpdateInfo(bean);
        }
    }

    private synchronized int updateConversationInfo(ConversationBean bean) {
        int[] result = new int[1];
        SQLiteDatabase db = mMyDBHelper.getDB();
        ContentValues values = new ContentValues();
        values.put(attributes[1], bean.getName());
        values.put(attributes[2], bean.getType() + "");
        values.put(attributes[3], bean.getLogoUrl());
        result[0] = db.update("ConversationDao", values, "uuid=?", new String[]{bean.getUuid()});
        LogUtils.d((Object)("\u83b7\u53d6\u66f4\u65b0\u7684\u6570\u636e(\u66f4\u65b0\u6570\u636e)ConversationDao" + String.valueOf(result[0])));
        return result[0];
    }

    public synchronized ConversationBean queryConversationByTargetId(String uuid) {
        ConversationBean[] bean = new ConversationBean[]{null};
        SQLiteDatabase db = mMyDBHelper.getDB();
        Cursor cursor = db.query("ConversationDao", attributes, "uuid=?", new String[]{uuid}, null, null, null);
        if (cursor != null && cursor.getCount() > 0) {
            while (cursor.moveToNext()) {
                bean[0] = new ConversationBean();
                bean[0].setUuid(cursor.getString(0));
                bean[0].setName(cursor.getString(1));
                bean[0].setType(Integer.parseInt(cursor.getString(2)));
                bean[0].setLogoUrl(cursor.getString(3));
            }
        }
        LogUtils.d((Object)("\u83b7\u53d6\u66f4\u65b0\u7684\u6570\u636e(\u67e5\u8be2\u6570\u636e)ConversationDao" + String.valueOf(bean[0])));
        cursor.close();
        return bean[0];
    }

    public synchronized void clearData() {
        if (mMyDBHelper == null) {
            return;
        }
        SQLiteDatabase db = mMyDBHelper.getDB();
        int result = db.delete("ConversationDao", null, null);
        LogUtils.d((Object)("\u6e05\u7a7a\u6570\u636eConversationDao" + result + ""));
    }
}

