/*
 * Decompiled with CFR 0.152.
 */
package com.kangxin.doctor.libdata.http.interceptor;

import android.util.Log;
import com.google.gson.Gson;
import com.google.gson.JsonObject;
import com.kangxin.doctor.libdata.http.bean.RequestNetBean;
import java.io.IOException;
import java.nio.charset.Charset;
import okhttp3.Interceptor;
import okhttp3.MediaType;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okio.Buffer;
import okio.BufferedSink;

public class HeadInterceptor
implements Interceptor {
    private static final Charset UTF8 = Charset.forName("UTF-8");
    private static final String TAG = "HeadInterceptor";

    public Response intercept(Interceptor.Chain chain) throws IOException {
        RequestBody requestBody = chain.request().body();
        Buffer buffer = new Buffer();
        requestBody.writeTo((BufferedSink)buffer);
        Charset charset = UTF8;
        MediaType contentType = requestBody.contentType();
        if (contentType != null) {
            charset = contentType.charset(UTF8);
        }
        String body = buffer.readString(charset);
        Log.i((String)TAG, (String)("HeadInterceptor==body==" + body));
        JsonObject bodyBean = (JsonObject)new Gson().fromJson(body, JsonObject.class);
        JsonObject real = new JsonObject();
        real.addProperty("body", bodyBean.toString());
        RequestNetBean requestNetBean = new RequestNetBean(bodyBean);
        String s = new Gson().toJson((Object)requestNetBean);
        RequestBody realBody = RequestBody.create((MediaType)MediaType.parse((String)"Content-Type, application/json"), (String)new Gson().toJson((Object)requestNetBean).toString());
        Request request = chain.request().newBuilder().post(realBody).addHeader("Content-Type", "application/json;charset=UTF-8").addHeader("Accept", "application/json").addHeader("Content-Type", "application/x-www-form-urlencoded").build();
        return chain.proceed(request);
    }
}

